#include "Leggi.h"

/*
*
* CondWriteLine()
*
* writes the i-th line of the DisplayStatus checking first if it must refresh it.
* Returns TRUE if a refresh action was taken.
*
*/

int CondWriteLine(DisplayStatus *D, int n, int pos) {

	if (!D->RefreshState[n]) {
		D->RefreshState[n] = 1;
		WriteLine(D, D->TLine+n, pos);
		return(1);
	}
	return(0);
}




/*
*
* StrongRefreshDisplayStatus()
*
* takes a DisplayStatus pointer and does a "strong" RefreshDisplayStatus,
* IE takes care of the gadget, set heights/PixLen and wipes the window.
*
*/

void StrongRefreshDisplayStatus(DisplayStatus *D) {
	D->PixLen = SetHeights(D);
	D->PropInfo.Flags &= ~KNOBHIT;
	RefreshDisplayStatus(D);
	WipeWindow(D);
}


/*
*
* RefreshDisplayStatus()
*
* takes a DisplayStatus pointer and using Window and TLine sets the BLine,
* WindowLines, BLinePixel and RefreshState entries and if the Gadget has not been
* hit sets it too. Not that if the PixLen is < of the Window PixLen the top line
* becomes to the top of file.
*
*/

void RefreshDisplayStatus(DisplayStatus *D) {

	int t;

	D->BLine = FindBottomLine(D, D->OldTLine = D->TLine);

	if (D->WindowLines>(t=D->BLine-D->TLine)) memset(D->RefreshState+t, 0, D->WindowLines-t);
	D->WindowLines = (t != 0) ? t : 1;

	D->BLinePixel = GetPixelValue(D->TLine, D->BLine-1);

	if (D->Options & LINENUMBERS) {
		if (D->TitleLen) SPrintf(D->Window->Title + D->TitleLen + 3 + (D->WindowNumber>9), "  %05ld:%05ld", D->TLine-D->Buffer+1, D->LineLen);
		ResetWindowTitle(D->Window);
	}

	if (!(D->PropInfo.Flags & KNOBHIT)) SetPropGadget(D);
}


/*
*
* GetFileName()
*
* is a "DisplayStatused" interface to the ARP file requester. Puts the result
* in D->Arg. If Dir is non-NULL, it copies it in the curdir field. If it's NULL,
* it tries to get a current dir from the Window title. If a D->Arg is already
* present, returns.
*
*/

void GetFileName(DisplayStatus *D, char *Hail, char *Dir) {

	struct FileRequester *FileRequester;
	char *Sel;

	if (D->Arg[0]) return;

	if ((FileRequester = ArpAllocFreq()) == NULL) return;

	ArgClear(D);
	FileRequester->fr_Hail = Hail;
	FileRequester->fr_Flags2 |= FR2F_LongPath;
	if (Dir) strcpy(FileRequester->fr_Dir, Dir);
	else {
		strcpy(FileRequester->fr_Dir, D->Window->Title);
		FileRequester->fr_Dir[D->TitleLen]=0;
		if ((Sel = BaseName(FileRequester->fr_Dir)) != FileRequester->fr_Dir && *(Sel-1) != ':') *(Sel-1) = 0;
			else *Sel = 0;
	}

	if ((Sel = FileRequest(FileRequester)) && (*Sel)) {
		TackOn(FileRequester->fr_Dir, FileRequester->fr_File);
		ArgSet(D, FileRequester->fr_Dir);
	}

	FreeTrackedItem((void *)FileRequester);
}

/*
*
* MyGetString()
*
* calls NewGetString with the given title and stores the result in the given
* buffer.  If a valid D->Arg it's already present, returns it.  If
* something is wrong (error/no answer) return -1 setting D->RC correctly.
*
*/

int MyGetString(DisplayStatus *D, char *Title, char *Buffer, int BufLen) {

	static struct GetStringStruct GetStringStruct;

	if (D->Arg[0]) {
		strncpy(Buffer, D->Arg, BufLen-1);
		return(NULL);
	}
	else if (ReqBase) {
		GetStringStruct.titlebar = Title;
		GetStringStruct.stringbuffer = Buffer;
		GetStringStruct.stringsize = BufLen-1;
		GetStringStruct.visiblesize = BufLen/2;
		if (NewGetString(&GetStringStruct)) return(NULL);
	}

	D->RC = 1;
	return(-1);

}

/*
*
* GetNumber()
*
* calls GetLong with the given title, maxlimit, minlimit, and default value or
* no default value if 0 is given as default value (phew!). If a valid D->Arg it's
* already present, returns it. If something is wrong (error/no answer) return -1
* setting D->RC correctly.
*
*/

int GetNumber(DisplayStatus *D, char *Title, int MinLim, int MaxLim, int DefVal) {

	static struct GetLongStruct GetLongStruct;
	int t;

	if (D->Arg[0] && 	(t = Atol(D->Arg))>=MinLim && t<=MaxLim && !IoErr()) return(t);
	else if (!D->Arg[0] && ReqBase) {
		GetLongStruct.titlebar = Title;
		GetLongStruct.minlimit = MinLim;
		GetLongStruct.maxlimit = MaxLim;
		GetLongStruct.flags = DefVal<0 ? GLNODEFAULTM : 0;
		GetLongStruct.defaultval = DefVal;
		if (GetLong(&GetLongStruct)) return(GetLongStruct.result);
	}

	D->RC = 1;
	return(-1);

}

/*
*
* ChangeMargin()
*
* takes a DisplayStatus pointer, and an increment and
* changes the margin if possible, setting also the refresh.
*
*/

void ChangeMargin(DisplayStatus *D, int Increment) {

	if (D->LMargin+Increment<4096 && D->LMargin+Increment>-4096) {
		D->LMargin += Increment;
		WipeWindow(D);
	}
	else D->RC = 1;
}


/*
*
* OKIfchanged()
*
* is a stupid functions that sets RC = (D->TLine == D->OldTLine).
*
*/

void OKIfChanged(DisplayStatus *D) {

	D->RC = (D->TLine == D->OldTLine);
}


/*
*
* SetTitleMarkers()
*
* sets the first DisplayStatus title to "#" and the second one to "".
*
*/

void SetTitleMarkers(struct MinList *H) {

	register DisplayStatus *OldH, *NewH;

	if (H->mlh_Head->mln_Succ->mln_Succ) {
		NewH = FirstDisplayStatus(H);
		OldH = SuccDisplayStatus(NewH);
		OldH->StdTitle[0] = OldH->Window->Title[OldH->TitleLen+(OldH->TitleLen!=0)]='#';
		ResetWindowTitle(OldH->Window);
		NewH->StdTitle[0] = NewH->Window->Title[NewH->TitleLen+(NewH->TitleLen!=0)]='';
		ResetWindowTitle(NewH->Window);
	}
}


/*
*
* FindWindowNumber()
*
* returns (if it exists) the address of a DisplayStatus with a given WindowNumber
* starting with a given DisplayStatus (that can be NULL). If nothing is found,
* returns NULL.
*
*/

DisplayStatus *FindWindowNumber(struct MinList *H, int n) {

	DisplayStatus *D = FirstDisplayStatus(H);

		while (SuccDisplayStatus(D)) {
			if (n == ((DisplayStatus *)D)->WindowNumber) return(D);
			D = SuccDisplayStatus(D);
		}

	return(NULL);
}
