#include "Leggi.h"


static LONG RefreshType=SIMPLE_REFRESH;

static void SWT(struct Window *w, char *p) {
	SetWindowTitles(w, p, (void *)(-1));
}

/*
*
* DoAction()
*
* is the most important routine. It takes an action, a DisplayStatus on which
* to act, and a DisplayStatus list header.  Every action implemented in
* Leggi.h is realized here. Many actions check first if there is an argument
* and if not they ask it through a requester.
+
*/


void DoAction(int Action, DisplayStatus *D, struct MinList *H) {

	register int i, j, t;
	register LDesc *L;
	register DisplayStatus *T;
	char *p, *q;
	short x[2];


	if (D) D->RC = 0;

	switch(Action) {
		case PAGE_UP:	D->TLine = PageBackward(D);
							OKIfChanged(D);
							break;

		case PAGE_DOWN:D->TLine = PageForward(D);
							OKIfChanged(D);
							break;

		case LINE_UP:	if (D->TLine > D->Buffer) D->TLine--;
							OKIfChanged(D);
							break;

		case LINE_DOWN:if (D->BLine->Line) D->TLine++;
							OKIfChanged(D);
							break;

		case GO_TOP:	D->TLine = D->Buffer;
							break;

		case GO_BOTTOM:D->TLine = Bottom(D);
							break;

		case PAGE_PREV:
		case PAGE_NEXT:	if (L = Search(D, D->PageKey, Action==PAGE_NEXT ? 1 : -1)) D->TLine = L;
								OKIfChanged(D);
								break;

		case TLINE_CHANGED:	if ((t = GetNumber(D, "Jump To Line", 1, D->LineLen, -1))>-1) {
										D->TLine = D->Buffer+t-1;
										if (D->TLine!=D->OldTLine) WipeWindow(D);
									}
									break;

		case MARGIN_LEFT:	ChangeMargin(D, -D->FontTable[MAXFONTS]->tf_XSize*4);
								break;

		case MARGIN_RIGHT:ChangeMargin(D, D->FontTable[MAXFONTS]->tf_XSize*4);
								break;

		case SCREEN_LEFT:	ChangeMargin(D, -WindowSkip(D));
								break;

		case SCREEN_RIGHT:ChangeMargin(D, WindowSkip(D));
								break;

		case CENTER_MARGIN:	ChangeMargin(D, -D->LMargin);
									break;

		case SET_SIZE:			p = D->Arg;
									x[0] = D->Window->Width;
									x[1] = D->Window->Height;
									for(i=0; i<2; i++) {
										q = p;
										while(*p && *p!='/') p++;
										if (p!=q) *(p++) = 0;
										if ((t = Atol(q))>=0 && !IoErr()) x[i]=t;
									}
									if (	x[0]>=D->Window->MinWidth && x[1]>=D->Window->MinHeight
											&& x[0]+D->Window->LeftEdge <= D->Window->WScreen->Width
											&& x[1]+D->Window->TopEdge <= D->Window->WScreen->Height	) {
										SizeWindow(D->Window, x[0]-D->Window->Width, x[1]-D->Window->Height);
										Delay(20);
									}

		case SIZE_WINDOW:	UnClipToBorders(D->Window, D->BorderRegion);
								D->BorderRegion =  ClipToBorders(D->Window);
								D->WindowPixLen = WindowPixLen(D->Window);
								if ((D->LineLen <= FindBottomLine(D, D->Buffer)-D->Buffer) && (D->TLine != D->Buffer)) {
									WipeWindow(D);
									D->TLine = D->Buffer;
								}
								else if (D->LineLen>1) WriteLine(D, D->BLine, D->BLinePixel+(D->BLine-1)->Height);
								D->PropInfo.Flags &= ~KNOBHIT;
								RefreshDisplayStatus(D);
								break;

		case REFRESH_WINDOW:	if (D->DoRefresh) WipeWindow(D);
									RefreshWindow(D);
									break;

		case REDISPLAY_WINDOW:	WipeWindow(D);
										break;

		case REFRESH_LINES:	if (D->DoWipe) {
										SetRast(D->Window->RPort, D->DoWipe = 0);
										StripRefreshMessages(D->Window);
										memset(D->RefreshState, 0, D->WindowLines);
									}

									if (D->DoRefresh<0) {
										i=D->WindowLines-1;
										t=D->BLinePixel;
									}
									else if (D->DoRefresh>0) {
										i=0;
										t=0;
									}
									for(j = 0; (j<REFRESHCYCLES) && (D->DoRefresh); j++) {
										if (D->DoRefresh<0) {
											while(!CondWriteLine(D, i, t)) {
												t-=(D->TLine+i-1)->Height;
												if (--i<0) break;
											}
											if (i==-1) D->DoRefresh = 0;
										}
										else if (D->DoRefresh>0) {
												while(!CondWriteLine(D, i, t)) {
													t+=(D->TLine+i)->Height;
													if (++i>=D->WindowLines) break;
												}
										if (i==D->WindowLines) D->DoRefresh = 0;
										}
									}
									break;

		case OPEN_WINDOW:	if (T = CreateDisplayStatus(H, RefreshType)) {
									SetTitleMarkers(H);
									if (D) {
										T->Options = D->Options;
										T->TabSize = D->TabSize;
										T->WordWrap = D->WordWrap;
										T->LineSpacing = D->LineSpacing;
									}
								}
								return;

		case CHANGE_FONT: GetFileName(D, "Select a font/size", "FONTS:~*.font");
								if (ChangeDefaultFont(D)) StrongRefreshDisplayStatus(D);
								else D->RC = 5;
								break;

		case FREE_ALL_FONTS: ResetFonts(D);
									StrongRefreshDisplayStatus(D);
									break;

		case OPEN_FILE:	if (D->Arg[0]) {
									WindowToFront(D->Window);
									ActivateWindow(D->Window);
								}
								GetFileName(D, "Select a file to open", NULL);
								if (!D->Arg[0]) break;
								ResetDisplayStatusBuffers(D);

								if (OpenAndCrunch(D)) {
									if (p = AllocRemember(&D->RememberKey, strlen(D->Arg)+SPACEFORCOLROWNUMBERS, MEMF_CLEAR | MEMF_PUBLIC)) {
										D->TitleLen = strlen(D->Arg);
										strcpy(p, D->Arg);
										SPrintf(p + D->TitleLen, " %s", D->StdTitle);
										SWT(D->Window, p);
									}
								}
								else {
									ResetDisplayStatusBuffers(D);
									D->RC = 5;
									DisplayBeep(NULL);
								}
								StrongRefreshDisplayStatus(D);
								break;

		case SAVE_ASCII:	GetFileName(D, "Save as an ASCII file", NULL);
								SaveAsASCII(D);
								break;

		case CLOSE_WINDOW:	DeleteDisplayStatus(D, H);
									SetTitleMarkers(H);
									return;

		case CLOSE_ALL:	D = FirstDisplayStatus(H);
									while(T = SuccDisplayStatus(D)) {
										DeleteDisplayStatus(D, H);
										D = T;
									}
								return;

		case SET_SMOOTH:	D->Options |= SMOOTHSCROLLING;
								break;

		case SET_GROSSIER:	D->Options &= ~SMOOTHSCROLLING;
									break;

		case SET_SMART:	RefreshType = SMART_REFRESH;
								return;

		case SET_SIMPLE:	RefreshType = SIMPLE_REFRESH;
								return;

		case NUMBERS_ON:	D->Options |= LINENUMBERS;
								D->Window->Title[D->TitleLen+3+(D->WindowNumber>9)] = ' ';
								RefreshDisplayStatus(D);
								break;

		case NUMBERS_OFF:	D->Options &= ~LINENUMBERS;
								D->Window->Title[D->TitleLen+3+(D->WindowNumber>9)] = 0;
								ResetWindowTitle(D->Window);
								break;

		case SET_TAB_SIZE:	if ((t = GetNumber(D, "Tab Size", 1, 1024, D->TabSize))>0) {
										D->TabSize = t;
										WipeWindow(D);
									}
									break;

		case SET_WORDWRAP:	if ((t=GetNumber(D, "Wordwrap", 0, 1024, D->WordWrap))>=0)
										D->WordWrap = t;
									break;

		case SET_LINE_SPACING:	if ((t=GetNumber(D, "Line Spacing", 0, 32, D->LineSpacing))>=0) {
											D->LineSpacing = t;
											StrongRefreshDisplayStatus(D);
										}
										break;


		case SET_PAGE_KEY:	MyGetString(D, "Page Key", D->PageKey, PAGEKEYLENGTH);
									break;

		case SEARCH_AGAIN:
		case SEARCH_AGAIN_BACK:
		case DO_SEARCH:	if ((Action != DO_SEARCH) || !MyGetString(D, "Find", D->SearchString, SEARCHSTRINGLENGTH))
									if (L = Search(D, D->SearchString, Action==SEARCH_AGAIN_BACK ? -1 : 1)) {
										WipeWindow(D);
										D->TLine = L;
									}
								break;

		case SELECT_WINDOW:	if (!(t = Atol(D->Arg))) t = D->WindowNumber;
									if (!IoErr())
										if (T  = FindWindowNumber(H, t)) {
											if (T != FirstDisplayStatus(H)) {
												Remove((struct Node *)T);
												AddHead((struct List *)H, (struct Node *)T);
												SetTitleMarkers(H);
											}
											WindowToFront(T->Window);
											ActivateWindow(T->Window);
											return;
										}
									D->RC = 5;
									break;

		case WINDOW_TO_FRONT:	if ((t = Atol(D->Arg)) && t>0 && !IoErr() && (T = FindWindowNumber(H, t))) {
											WindowToFront(T->Window);
											ActivateWindow(T->Window);
										}
										else D->RC = 1;
										break;
	}

	if (D->OldTLine != D->TLine) {

		if (D->OldTLine < D->TLine) D->DoRefresh = 1;
		 else D->DoRefresh = -1;

		if ((D->TLine > D->OldTLine) && (D->TLine < D->BLine))
			 ScrollUpLines(D);
		else if ((D->TLine < D->OldTLine) && (GetPixelValue(D->TLine, D->OldTLine) < D->WindowPixLen))
			 ScrollDownLines(D);
		else WipeWindow(D);

		RefreshDisplayStatus(D);
	}

}
