#include "Leggi.h"

#define ITALICON  3
#define ITALICOFF 23
#define UNDERLINEDON  4
#define UNDERLINEDOFF 24
#define BOLDON  1
#define BOLDOFF 22
#define PLAIN 0
#define FOREGROUNDID 3
#define BACKGROUNDID 4
#define FONTS "BRKAEHYZ"
#define TSEQLEN 20

/*
*
* The ANSI/ISO parsing automaton.
*
* WARNING: The following variables MUST be inizialized with a call to InitAutomaton()
* before calling the automaton.
*
* Why doesn't C give me nested functions?
*/

short State, CurrentPos, TabSize=8, WordWrap=0;
unsigned char CurrentFont, CurrentColor, EscSeq[TSEQLEN], *p, *StartLine, *StartSeq, Class[256], Fonts[]=FONTS;
LDesc *LineDesc;
long Len;

enum States { NORMAL, ESCSEQ, SHORTSUBSEQ, LONGSUBSEQ, ENDLINE, CHECKSEQ, STATESCOUNT };
enum Classes { OTHER, ALPHA, SYMBOL, SQBRA, SHSEQ, CSI, ESC, CR, CLASSESCOUNT };

unsigned char Transition[STATESCOUNT][CLASSESCOUNT] =
	{
		{	NORMAL, NORMAL, NORMAL, NORMAL, NORMAL, LONGSUBSEQ, ESCSEQ, ENDLINE },
		{	NORMAL, NORMAL, NORMAL, LONGSUBSEQ, SHORTSUBSEQ, LONGSUBSEQ, ESCSEQ, ENDLINE },
		{  NORMAL, CHECKSEQ, NORMAL, NORMAL, NORMAL, LONGSUBSEQ, ESCSEQ, ENDLINE },
		{	NORMAL, CHECKSEQ, LONGSUBSEQ, LONGSUBSEQ, LONGSUBSEQ, LONGSUBSEQ, ESCSEQ, ENDLINE },
		{	NORMAL, NORMAL, NORMAL, NORMAL, NORMAL, LONGSUBSEQ, ESCSEQ, ENDLINE },
		{	NORMAL, NORMAL, NORMAL, NORMAL, NORMAL, LONGSUBSEQ, ESCSEQ, ENDLINE }
	};

/*
*
* InitAutomaton()
*
* initializes the global fields.
*
*/


void InitAutomaton(DisplayStatus *D, LDesc *LD) {

	register int i;

	State = NORMAL;
	LineDesc = LD;
	CurrentFont = LD->Font = 0;
	CurrentColor = LD->Color = 1;

	if (!Class[10]) {
		for(i=' '; i<'A'; i++) Class[i] = SYMBOL;
		for(i='A'; i<='Z'; i++) Class[i] = Class[i+32] = ALPHA;
		Class['['] = SQBRA;
		Class['('] = Class['#'] = SHSEQ;
		Class[0x0a] = CR;
		Class[0x1b] = ESC;
		Class[0x9b] = CSI;
	}
}

/*
*
* EndAutomaton()
*
* correctly ends the automaton work. Returns the last LineDesc used (its Line
* is NULL).
*
*/

LDesc *EndAutomaton(DisplayStatus *D) {
	LineDesc->Line = NULL;
	return(LineDesc);
}

/*
*
* InitSeqParsing()
*
* initializes everything for the sequence parsing.
*
*/

void InitSeqParsing(void) {
	StartSeq = p-1;
	memset(EscSeq, 0, TSEQLEN);
}

/*
*
* CloseSeqParsing()
*
* frees everything from the sequence parsing.
*
*/

void CloseSeqParsing(void) {

	register unsigned char *q = StartSeq;

	if (p-q>2) {
		*(q++) = 0;
		*(q++) = CurrentFont;
		*(q++) = CurrentColor;

		while(q<p) *(q++)=SKIPCHAR;
	}
}




/*
*
* ParseASCIIChars()
*
* takes a pointer to a a source buffer and the length of the buffer. Outputs
* to the LineDesc and dest pointers initialized by InitAutomaton().
* This is the real automaton.
*
*/

__asm short transition(register __d0 short int);

void ParseASCIIChars(char *source, int len) {

	unsigned char CurrentChar;
	int i;

	p = source;
	LineDesc->Line = p;
	StartLine = p;
	Len = len;

	while(p-source<len)
		if (State = transition(State)) {

			CurrentChar = *(p-1);
			switch(State) {
				case ESCSEQ:	InitSeqParsing();
									break;

				case LONGSUBSEQ:	if ((CurrentChar != '[') && (CurrentChar != 0x9b)) EscSeq[strlen(EscSeq)<TSEQLEN-2 ? strlen(EscSeq) : TSEQLEN-2 ] = CurrentChar;
										else if (CurrentChar == 0x9b) InitSeqParsing();
										break;

				case CHECKSEQ: if (CurrentChar == 'm') {
										ParseEscSeq();
										CloseSeqParsing();
									}
									else if (!EscSeq[0]) {
										for(i=0; i<strlen(FONTS); i++) if (CurrentChar == Fonts[i])
											CurrentFont = (CurrentFont & 0x7) | (8*i);
										CloseSeqParsing();
									}
									break;

				default:			break;

			}
		}
}


/*
*
* ParseEscSeq()
*
* parses the Esc-sequence and sets CurrentFont, CurrentColor.
*
*/

void ParseEscSeq(void) {

	register unsigned char *p = EscSeq, *q;
	register int i;

	do {
		q = p;
		while((*p>='0') && (*p<='9')) p++;
		*(p++)=0;
		i = Atol(q);
		if (!IoErr()) switch(i) {
			case BOLDON:
				CurrentFont |= FSF_BOLD;
				break;
			case ITALICON:
				CurrentFont |= FSF_ITALIC;
				break;
			case UNDERLINEDON:
				CurrentFont |= FSF_UNDERLINED;
				break;
			case BOLDOFF:
				CurrentFont &= ~FSF_BOLD;
				break;
			case ITALICOFF:
				CurrentFont &= ~FSF_ITALIC;
				break;
			case UNDERLINEDOFF:
				CurrentFont &= ~FSF_UNDERLINED;
				break;
			case PLAIN:
				CurrentFont &= ~(FSF_BOLD | FSF_ITALIC | FSF_UNDERLINED);
				CurrentColor = 1;
			default:
				if ((i%10>=0) & (i%10<8))
					switch(i/10) {
						case FOREGROUNDID:
							CurrentColor &= ~7;
							CurrentColor |= i%10;
							break;
						case BACKGROUNDID:
							CurrentColor &= 7;
							CurrentColor |= (i%10)*8;
							break;
						default:
							break;
					}
		}
	} while(*p);
}
