#include "AllIncludes.c"

#define MakeID(a,b,c,d)  ( (ULONG)(a)<<24L | (ULONG)(b)<<16L | (c)<<8 | (d) )
#define FORM    MakeID('F','O','R','M')
#define ID_FTXT MakeID('F','T','X','T')
#define ID_CHRS MakeID('C','H','R','S')
#define ID_FONS MakeID('F','O','N','S')
#define CHUNKID(x) (*((ULONG *)(x)))
#define CHUNKLEN(x) (*((ULONG *)((x)+4)))

char *CLI_Template = "IFFFILE/A,ASCIIFILE/A";
char *CLI_Help = "\n[1;33mDeIFF[0m  1990 Sebastiano Vigna\nUsage: DeIFF <IFF filename> <ASCII filename>\n";

extern void *ArpBase;

int main(int argc, char **argv) {

	char *p, *q;
	long chunklen, h, l;

	if (argc<3) {
		Puts(CLI_Help);
		return(0);
	}

	if (h = ArpOpen(argv[1], MODE_OLDFILE)) {

		Seek(h, 0, OFFSET_END);
		l = Seek(h, 0, OFFSET_BEGINNING);

		if (p = ArpAlloc(l)) {
			q = p + 12;
			Read(h, p, l--);
			if (h = ArpOpen(argv[2], MODE_NEWFILE)) {
				while(q-p<l) {
					chunklen = CHUNKLEN(q);
					if (CHUNKID(q) == ID_CHRS) Write(h, q+8, chunklen);
					q += chunklen + chunklen%2 + 8;
				}
			}
			else Puts("Can't open output file");
		}
		else Puts("Not enough memory!");
	}
	else Puts("File not found");

	return(0);
}
