#include "Leggi.h"

#define MakeID(a,b,c,d)  ( (ULONG)(a)<<24L | (ULONG)(b)<<16L | (c)<<8 | (d) )
#define FORM    MakeID('F','O','R','M')
#define ID_FTXT MakeID('F','T','X','T')
#define ID_CHRS MakeID('C','H','R','S')
#define ID_FONS MakeID('F','O','N','S')
#define CHUNKID(x) (*((ULONG *)(x)))
#define CHUNKLEN(x) (*((ULONG *)((x)+4)))

typedef struct {
	UBYTE id;
	UBYTE pad1;
	UBYTE proportional;
	UBYTE serif;
	char name[100];
} FontSpecifier;


__asm int setheights(register __a0 LDesc *, register __a1 struct TextFont **, register __d1 long);


/*
*
* SetHeights()
*
* takes a DisplayStatus *, sets correctly Heights and Baselines
* and returns the total length.
*
*/

int SetHeights(DisplayStatus *D) {

	return(setheights(D->Buffer, D->FontTable, D->LineSpacing));
}

/*
*
* IsFTXT()
*
* takes a char *, and tells you if the file is FTXT.
*
*/

int IsFTXT(char *p) {
	return( (CHUNKID(p) == FORM) && (CHUNKID(p+8) == ID_FTXT) );
}

/*
*
*
* OpenAndCrunch()
*
* Opens an IFF or ASCII file, converting it to Leggi's internal buffer;
* Writes through BufPointer the LineDesc's array; returns zero if error,
* otherwise a valid RememberKey to dealloc the file. The FontTable is set
* up if it's an FTXT file. Some of the internal value are set up, but NOT
* the heights!
*/

__asm long countnewlines(register __a0 char *p, register __d0 long WordWrap, register __d1 long Length);

int OpenAndCrunch(DisplayStatus *D) {

	long int h, l, newlines;
	register char *p;

	if (PPBase) {
		if (ppLoadData(D->Arg, DECR_NONE, MEMF_PUBLIC, &D->FileBuffer, &D->FileBufferSize, NULL)) return(NULL);
		else {
			p = D->FileBuffer;
			l = --D->FileBufferSize;
		}
	}
	else {
		if (h = Open(D->Arg, MODE_OLDFILE)) {
			Seek(h, 0, OFFSET_END);
			l = Seek(h, 0, OFFSET_BEGINNING);
			if (p = AllocMem(l+1, MEMF_PUBLIC)) {
				Read(h, p, l);
				D->FileBuffer = p;
				D->FileBufferSize = l;
			}
			Close(h);
			if (!p) return(NULL);
		}
		else return(NULL);
	}
	if (IsFTXT(p)) ParseFTXTFile(D, p+12, l-12);
	else {
		if (p[l-1]!='\n') p[l++]='\n';
		newlines = countnewlines(p, D->WordWrap, l)+1;

		if (D->Buffer = (void *)AllocRemember(&D->RememberKey, newlines*sizeof(LDesc), MEMF_PUBLIC | MEMF_CLEAR)) {

/*Printf("Allocati: linee:%ld caratteri:%ld\n", newlines, l+1);*/

			InitAutomaton(D, D->Buffer);
			ParseASCIIChars(p, l);
		}
		else {
			FreeMem(D->FileBuffer, D->FileBufferSize+1);
			D->FileBuffer = NULL;
		}
	}
	if (D->RememberKey) {
		D->OldTLine = D->TLine = D->Buffer;
		D->LineLen = EndAutomaton(D) - D->Buffer;
/*Printf("Usati: linee: %ld  caratteri: %ld\n", D->LineLen+1, (D->Buffer+D->LineLen-1)->Line-D->Buffer->Line);*/
		return(1);
	}
	return(NULL);
}

/*
*
* ParseFTXTFile()
*
* takes a pointer to a read buffer, the len of the buffer and a pointer to a
* FontTable. It parses the buffer as a IFF file and sets up the FontTable.
*
*/

void ParseFTXTFile(DisplayStatus *D, char *source, int len) {

	char *q = source;
	long chunklen, newlines=0, i;
	FontSpecifier *FontS;
	struct TextFont *TFont;

	while(q-source<len) {
		chunklen = CHUNKLEN(q);
		if (CHUNKID(q) == ID_CHRS) {
			*(q+7+chunklen)='\n';
			newlines += countnewlines(q+8, D->WordWrap, chunklen);
		}
		else if (CHUNKID(q) == ID_FONS) {
				FontS = (FontSpecifier *)(q+8);
				if ((FontS->id>=0) && (FontS->id<MAXFONTS)) {

					TFont = D->FontTable[FontS->id];

					if (D->FontTable[FontS->id] = OpenFontNamed(FontS->name, D->FontTable[MAXFONTS]->tf_YSize)) {
							CloseFontSafely(&TFont, D->FontTable);
							if (FontS->id == 0) {
								CloseFont(D->FontTable[MAXFONTS]);
								for(i=1; i<=MAXFONTS; i++)
									if (D->FontTable[i] == D->FontTable[MAXFONTS]) D->FontTable[i] = D->FontTable[0];
							}
						}
					else D->FontTable[FontS->id] = TFont;
				}
			}
		q += chunklen + chunklen%2 + 8;
	}

	if ((newlines) && (D->Buffer = (void *)AllocRemember(&D->RememberKey, (newlines+1)*sizeof(LDesc), MEMF_PUBLIC | MEMF_CLEAR))) {

/*Printf("Allocati: linee:%ld caratteri:%ld\n", newlines+1, len);*/

		InitAutomaton(D, D->Buffer);

		q = source;

		while(q-source<len) {
			chunklen = CHUNKLEN(q);
			if (CHUNKID(q) == ID_CHRS) ParseASCIIChars(q+8, chunklen);
			q+=chunklen+chunklen%2+8;
		}
	}
	else {
		FreeRemember(&D->RememberKey, TRUE);
		FreeMem(D->FileBuffer, D->FileBufferSize+1);
		D->FileBuffer = NULL;
	}
}



/*
*
* SaveAsASCII()
*
* saves the DisplayStatus pointed file in an ASCII format, with the name
* in D->Arg. Returns a non-NULL value is something is wrong.
*
*/

void SaveAsASCII(DisplayStatus *D) {

	int h, pos, i;
	register LDesc *LineDesc;
	register char *l;

	if (h = Open(D->Arg, MODE_NEWFILE)) {

		LineDesc = D->Buffer-1;

		while(l = (++LineDesc)->Line) {
			pos = 0;
			while(l-LineDesc->Line < LineDesc->Length)
				if (!*l) l = (char *)skipneg(l+3);
				else if (*l == TABCHAR) {
					for(i=0; i<D->TabSize-pos%D->TabSize; i++) Write(h, " ", 1);
					pos = (pos/D->TabSize+1)*D->TabSize;
					l++;
				}
				else {
					i = strlen(l);
					Write(h, l, i);
					pos += i;
					l += i;
				}
			Write(h, "\n", 1);
		}

		Close(h);
	}
	else D->RC = 1;
}
