#include "Leggi.h"

extern char OSVersion;

#define SCREENLEN 16
#define IDCMPFLAGS (GADGETDOWN | GADGETUP | NEWSIZE | CLOSEWINDOW | RAWKEY | MOUSEMOVE | MOUSEBUTTONS | MENUPICK | REFRESHWINDOW)

static char ScreenTitle[]="Leggi 1.1";

/*
*
* OpenWindowWithGadget()
*
* This routine opens a window for the DisplayStatus *D passed. The Type arg
* is used to decide what type of window (SMART/SIMPLE_REFRESH) has to be opened.
* If UserPort is non-NULL, it's used as IDCMP port.
*
*/

struct Window *OpenWindowWithGadget(DisplayStatus *D, ULONG RefreshType, struct MsgPort *UserPort) {

	struct NewWindow NewWindow;
	char Screen[SCREENLEN];

	setmem(&NewWindow, sizeof(struct NewWindow), 0);

	D->Gadget.GadgetType = PROPGADGET;
	D->Gadget.Flags = GADGIMAGE | GADGHCOMP | GRELRIGHT | GRELHEIGHT | GADGDISABLED;
	D->Gadget.GadgetRender = (APTR)&D->Image;
	D->Gadget.SpecialInfo = (APTR)&D->PropInfo;

	D->PropInfo.Flags = AUTOKNOB | FREEVERT | (OSVersion == 20 ? PROPNEWLOOK : NULL);
	D->PropInfo.VertPot = D->PropInfo.VertBody =
	D->PropInfo.HorizPot = D->PropInfo.HorizBody =
	NewWindow.MaxWidth = NewWindow.MaxHeight =  -1;

 	NewWindow.TopEdge = NewWindow.BlockPen = 1;
	NewWindow.MinWidth = 128;
	NewWindow.MinHeight = 64;

	NewWindow.Flags = RefreshType | WINDOWSIZING | WINDOWCLOSE | WINDOWDEPTH | WINDOWDRAG | ACTIVATE;
	NewWindow.IDCMPFlags = UserPort ? NULL : IDCMPFLAGS;
	NewWindow.Type = WBENCHSCREEN;

	GetScreenData(Screen, SCREENLEN, WBENCHSCREEN, NULL);
	NewWindow.Width = ((struct Screen *)Screen)->Width;
	NewWindow.Height = ((struct Screen *)Screen)->Height - 1;

	if (D->Window = OpenWindow(&NewWindow)) {
		if (UserPort) {
			D->Window->UserPort = UserPort;
			ModifyIDCMP(D->Window, IDCMPFLAGS);
		}
		D->Gadget.Activation = FOLLOWMOUSE | GADGIMMEDIATE | RELVERIFY | RIGHTBORDER;

		if (OSVersion == 13) {
			D->Gadget.Width = D->Window->BorderRight-2;
			D->Gadget.Height = - (D->Window->BorderTop + D->Window->BorderBottom + 6);
			D->Gadget.LeftEdge = - (D->Gadget.Width-1);
			D->Gadget.TopEdge = D->Window->BorderTop-1;
		}
		else {
			D->Gadget.Width = D->Window->BorderRight-8;
			D->Gadget.Height = - (D->Window->BorderTop + D->Window->BorderBottom + 10);
			D->Image.Width = D->Gadget.Width-2;
			D->Image.Height = D->Gadget.Height-2;
			D->Gadget.LeftEdge = - (D->Gadget.Width+3);
			D->Gadget.TopEdge = D->Window->BorderTop+1;
		}
		AddGadget(D->Window, &D->Gadget, ~0);
		RefreshGadgets(&D->Gadget, D->Window, NULL);
	}

	return(D->Window);
}


/*
*
* CreateDisplayStatus()
*
* takes a MinList header and a WindowType. Adds a new DisplayStatus
* structure to the top of the list.
* A window is opened, with a shared IDCMP and a
* menu strip from H if H is non-NULL. The WindowType is used to choose which
* refresh type should be used for the window.
*
*/

DisplayStatus *CreateDisplayStatus(struct MinList *H, int RefreshType) {

	register DisplayStatus *NewD;
	register int i;

	if ((NewD = AllocMem(sizeof(DisplayStatus), MEMF_PUBLIC | MEMF_CLEAR)) == NULL) return(NULL);

	if ((NewD->Window = OpenWindowWithGadget(NewD, RefreshType, IsEmpty(H) ? NULL : FirstDisplayStatus(H)->Window->UserPort)) == NULL) {
		FreeMem(NewD, sizeof(DisplayStatus));
		return(NULL);
	}

	NewD->Window->UserData = (void *)NewD;
	if IsNotEmpty(H) SetMenuStrip(NewD->Window, FirstDisplayStatus(H)->Window->MenuStrip);

	OpenSystemFont(NewD->FontTable);
	NewD->BorderRegion = ClipToBorders(NewD->Window);

	NewD->NullLineDesc[0].Height = NewD->NullLineDesc[0].Baseline = 8;
	NewD->Arg = NewD->NullLineDesc[0].Line = NewD->NullLine;
	NewD->NullLine[3] = -1;
	NewD->TabSize = 8;
	NewD->WindowPixLen = WindowPixLen(NewD->Window);

	AddHead((struct List *)H, (struct Node *)NewD);

	i=0;
	while (FindWindowNumber(H, ++i));
	NewD->WindowNumber = i;

	SPrintf(NewD->StdTitle, "%ld", NewD->WindowNumber);
	SetWindowTitles(NewD->Window, NewD->StdTitle, ScreenTitle);
	ResetDisplayStatusBuffers(NewD);
	return(NewD);
}



/*
*
* DeleteDisplayStatus()
*
* takes a DisplayStatus pointer, the List to which belongs and destroys it.
* If the list becomes void, delete also the IDCMP.
*
*/

void DeleteDisplayStatus(DisplayStatus *D, struct MinList *H) {

	Remove((struct Node *)D);

	UnClipToBorders(D->Window, D->BorderRegion);
	CloseWindowSafely(D->Window, (int)IsNotEmpty(H));
	FreeRemember(&D->RememberKey, TRUE);
	if (D->FileBuffer) {
		FreeMem(D->FileBuffer, D->FileBufferSize+1);
		D->FileBuffer = NULL;
	}

	CloseAllFonts(D->FontTable);
	CloseFont(D->FontTable[MAXFONTS]);

	ArgClear(D);
	FreeMem(D, sizeof(DisplayStatus));
}



/*
*
* ResetDisplayStatusBuffers()
*
* frees the Buffers in the given DisplayStatus.
*
*/

void ResetDisplayStatusBuffers(DisplayStatus *D) {

	SetWindowTitles(D->Window, D->StdTitle, (void *)(-1));
	D->BLinePixel = D->PixLen = D->TitleLen = D->LMargin = 0;
	D->LineLen = 1;
	FreeRemember(&D->RememberKey, TRUE);
	if (D->FileBuffer) {
		FreeMem(D->FileBuffer, D->FileBufferSize+1);
		D->FileBuffer = NULL;
	}

	CloseAllFonts(D->FontTable);

	D->Buffer = D->OldTLine = D->TLine = D->NullLineDesc;
	D->BLine = D->TLine + 1;
}

/*
*
* ArgAlloc()
*
* takes a DisplayStatus pointer, a len and allocs a buffer of that len, putting in
* D->Arg the result, that's also returned (ev. NULL). If D->Arg had a non-zero
* value, it's FreeTracked().
*
*/

void *ArgAlloc(DisplayStatus *D, int len) {

	ArgClear(D);
	if (D->Arg = ArpAlloc(len)) return(D->Arg);
	D->Arg = D->NullLine;
	return(NULL);
}

/*
*
* ArgClear()
*
* safely clears D->Arg and make it point to a NULL.
*
*/

void ArgClear(DisplayStatus *D) {
	if (D->Arg != D->NullLine) FreeTrackedItem((void *)D->Arg);
	D->Arg = D->NullLine;
}


/*
*
* ArgSet()
*
* sets the Arg of the given DisplayStatus to a given string (if possible).
* Returns a boolean value (the success).
*
*/

int ArgSet(DisplayStatus *D, char *String) {

	if (ArgAlloc(D, strlen(String)+1)) {
		strcpy(D->Arg, String);
		return(1);
	}
   return(NULL);
}

/*
*
* CreateMyMsg()
*
* takes a command (an int) and a string (ev. NULL) and creates a MyMessage structure
* with the given command and argument.
*
*/

struct MyMsg *SendMyMsg(int Cmd, char *Arg, struct MsgPort *SendPort, struct MsgPort *ReplyPort) {

	struct MyMsg *MyMessage;
	int MsgSize;

	MsgSize = sizeof(struct MyMsg)+(Arg && strlen(Arg)>3 ? strlen(Arg)-3: 0);

	if (MyMessage = AllocMem(MsgSize, MEMF_PUBLIC | MEMF_CLEAR)) {

		MyMessage->Cmd = Cmd;
		if (Arg) strcpy(MyMessage->Arg, Arg);
		MyMessage->ExecMsg.mn_Length = MsgSize-sizeof(struct Message);
		MyMessage->ExecMsg.mn_ReplyPort = ReplyPort;
		PutMsg(SendPort, (struct Message *)MyMessage);
	}

	return(MyMessage);
}


/*
*
* DeleteMyMsg()
*
* deletes a MyMsg structure
*
*/

void DeleteMyMsg(struct MyMsg *MyMessage) {

	FreeMem((void *)MyMessage, sizeof(struct Message)+MyMessage->ExecMsg.mn_Length);
}
