#include "Leggi.h"

#define BUFFERSIZE 512
#define PATHLEN 512

struct Library *LayersBase;
struct Library *DiskFontBase;
struct Library *PPBase;
struct ReqLib *ReqBase;

char CLI_Action[OPT_COUNT] = {
											NOTHING, OPEN_FILE, CHANGE_FONT, SET_PAGE_KEY,
											SET_SMOOTH, SET_GROSSIER, NUMBERS_ON,
											NUMBERS_OFF, SET_SMART, SET_SIMPLE,
											SET_TAB_SIZE, SET_WORDWRAP, SET_LINE_SPACING, SET_SIZE,
											OPEN_WINDOW, SAVE_ASCII, CLOSE_WINDOW, CLOSE_ALL,
											SELECT_WINDOW, WINDOW_TO_FRONT, GO_TOP,
											GO_BOTTOM, PAGE_UP, PAGE_DOWN, PAGE_PREV,
											PAGE_NEXT, LINE_UP, LINE_DOWN, TLINE_CHANGED,
											MARGIN_LEFT, MARGIN_RIGHT, SCREEN_LEFT,
											SCREEN_RIGHT, CENTER_MARGIN, DO_SEARCH,
											SEARCH_AGAIN, SEARCH_AGAIN_BACK,
											REDISPLAY_WINDOW, FREE_ALL_FONTS
										};

struct UserAnchor {
	struct AnchorPath ua_AP;
	BYTE path[PATHLEN-1];
};

char MyPortName[]="LeggiCom";
char ARexxPortName[]="LEGGI";
char StartupName[]="S:Startup-Leggi";

extern struct WBStartup *WBenchMsg;
static struct MinList Head;
static struct MsgPort *ARexxPort, *MyPort, *ReplyPort;
static struct MyMsg *MyMessage;
static struct RexxMsg *ARexxMessage;
static struct IntuiMessage *Message;
static struct UserAnchor *Anchor;
static char *Buffer;
static struct AllocRemember *MenuRemember;


/* MemCleanUp stub */

void MemCleanUp(void) {
}

int main(int argc, char **argv) {

	short int Action, Do, OnlyCom=1, f=0;
	long i;
	DisplayStatus *D;
	struct MinList *H = &Head;
	struct Menu *Menu;
	ULONG WaitMask;

	Forbid();

	if (!(ReplyPort = CreatePort(NULL,0))) goto GameOver;

	if (!(MyPort = FindPort(MyPortName))) {
		if (!(ARexxPort = CreatePort(ARexxPortName,0))) goto GameOver;
		if (!(MyPort = CreatePort(MyPortName,0))) goto GameOver;
		ReqBase = (struct ReqLib *)OpenLibrary("req.library", REQVERSION);
		PPBase = (struct Library *)OpenLibrary("powerpacker.library", 0);
		if ((MenuRemember = CreateMenu(&Menu)) == NULL) goto GameOver;
		OnlyCom = 0;
	}

	NewList((struct List *)H);

	if (argc) {
		for(i=2; i<OPT_COUNT; i++)
			if (argv[i])
				if (((CLI_Action[i] == SET_SMART) || (CLI_Action[i] == SET_SIMPLE)) && !OnlyCom)
					DoAction(CLI_Action[i], NULL, H);
				else SendMyMsg(CLI_Action[i], argv[i]==(void *)(-1) ? NULL : argv[i], MyPort, ReplyPort);

		i=-1;
		if (argv[1])
			if (Anchor = ArpAlloc(sizeof(struct UserAnchor))) {
				Anchor->ua_AP.ap_StrLen = PATHLEN;
				while(((char **)argv[1])[++i]) {
					if (!FindFirst(((char **)argv[1])[i], (struct AnchorPath *)Anchor)) {
						do {
							if (Anchor->ua_AP.ap_Info.fib_DirEntryType < 0) {
								if (f) SendMyMsg(OPEN_WINDOW, NULL, MyPort, ReplyPort);
								f = 1;
								SendMyMsg(OPEN_FILE, Anchor->ua_AP.ap_Buf, MyPort, ReplyPort);
							}
						} while(!FindNext((struct AnchorPath *)Anchor));
					}
					FreeAnchorChain((struct AnchorPath *)Anchor);
				}
				FreeTrackedItem((void *)Anchor);
			}
	}

	if (WBenchMsg)
		if (Buffer = ArpAlloc(BUFFERSIZE)) {
			for(i=1; i<WBenchMsg->sm_NumArgs; i++) {

				if (BaseName(WBenchMsg->sm_ArgList[i].wa_Name) == WBenchMsg->sm_ArgList[i].wa_Name) {
					PathName(WBenchMsg->sm_ArgList[i].wa_Lock, Buffer, BUFFERSIZE/DSIZE-2);
					TackOn(Buffer, WBenchMsg->sm_ArgList[i].wa_Name);
				}
				else strncpy(Buffer, WBenchMsg->sm_ArgList[i].wa_Name, BUFFERSIZE);
				if (i>1)
					SendMyMsg(OPEN_WINDOW, NULL, MyPort, ReplyPort);
				SendMyMsg(OPEN_FILE, Buffer, MyPort, ReplyPort);
			}
			FreeTrackedItem((void *)Buffer);
		}



	if (OnlyCom) SendMyMsg(NOTHING, NULL, MyPort, ReplyPort);

	Permit();

	if (OnlyCom)
		FOREVER {
			while (MyMessage = (void *)GetMsg(ReplyPort)) {
				if (MyMessage->Cmd == NOTHING) {
					DeleteMyMsg(MyMessage);
					DeletePort(ReplyPort);
					return(0);
				}
				DeleteMyMsg(MyMessage);
			}
			WaitPort(ReplyPort);
		}

	if (LayersBase = OpenLibrary("layers.library",0))
	if (DiskfontBase = OpenLibrary("diskfont.library",0)) {

	DoAction(OPEN_WINDOW, NULL, H);
	if (IsEmpty(H)) goto GameOver;

		SetMenuStrip(FirstDisplayStatus(H)->Window, Menu);

		WaitMask = (1 << FirstDisplayStatus(H)->Window->UserPort->mp_SigBit) | (1 << ARexxPort->mp_SigBit) | (1 << MyPort->mp_SigBit)| (1 << ReplyPort->mp_SigBit);

			FOREVER {

				do {

					Do = 0;

					if (Message = (void *)GetMsg(FirstDisplayStatus(H)->Window->UserPort)) {
						Action = ParseIDCMP(Message, D = (void *)Message->IDCMPWindow->UserData);
						ReplyMsg((void *)Message);
						DoAction(Action, D, H);
						if IsEmpty(H) goto GameOver;
						Do = 1;
						continue;
					}

					if (ARexxMessage = (void *)GetMsg(ARexxPort)) {
						Action = ParseARexx(ARexxMessage, FirstDisplayStatus(H));
						DoAction(Action, FirstDisplayStatus(H), H);
						ARexxMessage->rm_Result1 = IsEmpty(H) ? NULL : (Action==NOTHING ? 10 : FirstDisplayStatus(H)->RC);
						ARexxMessage->rm_Result2 = NULL;
						ReplyMsg((void *)ARexxMessage);
						if IsEmpty(H) goto GameOver;
						Do = 1;
						continue;
					}

					if (MyMessage = (void *)GetMsg(MyPort)) {
						Action = MyMessage->Cmd;
						if (MyMessage->Arg[0]) ArgSet(FirstDisplayStatus(H), MyMessage->Arg);
						else ArgClear(FirstDisplayStatus(H));
						D->PropInfo.Flags &= ~KNOBHIT;
						DoAction(Action, FirstDisplayStatus(H), H);
						ReplyMsg((void *)MyMessage);
						if IsEmpty(H) goto GameOver;
						Do = 1;
						continue;
					}

					if (MyMessage = (void *)GetMsg(ReplyPort)) {
						DeleteMyMsg((void *)MyMessage);
						Do = 1;
					}

					D = FirstDisplayStatus(H);
					while (SuccDisplayStatus(D)) {
						if (D->DoRefresh) {
							DoAction(REFRESH_LINES, D, H);
							Do = 1;
						}
						if (D->DoMove) {
							DoAction(D->DoMove, D, H);
							if (!D->KeepMove) D->DoMove = 0;
							Do = 1;
						}
						D = SuccDisplayStatus(D);
					}

				} while(Do);

				Wait(WaitMask);
			}

	}

GameOver:
	FreeRemember(&MenuRemember, TRUE);
	if (DiskfontBase) CloseLibrary(DiskfontBase);
	if (LayersBase) CloseLibrary(LayersBase);
	if (ReqBase) CloseLibrary((void *)ReqBase);
	if (PPBase) CloseLibrary((void *)PPBase);

	Forbid();

	if (ARexxPort) {
		while(ARexxMessage=(struct ARexxMessage *)GetMsg(ARexxPort)) {
			ARexxMessage->rm_Result1 = 30;
			ARexxMessage->rm_Result2 = NULL;
			ReplyMsg((struct Message *)ARexxMessage);
		}
		DeletePort(ARexxPort);
	}

	if (MyPort) {
		while(MyMessage=(struct MyMsg *)GetMsg(MyPort)) ReplyMsg((void *)MyMessage);
		DeletePort(MyPort);
	}

	if (ReplyPort) {
		while(MyMessage=(struct MyMsg *)GetMsg(ReplyPort)) DeleteMyMsg(MyMessage);
		DeletePort(ReplyPort);
	}

	Permit();

	return(0);
}
