#include "AllIncludes.c"


/*
* Leggi's internal file description:
*
* An array of
*
* [line][height][baseline][Length][Font][Color]
*  LONG   WORD     WORD    WORD    CHAR  CHAR
*
* the last element must have line==NULL.
*
* Line points to:
*
* ( [char] | [TAB] | [ESCGROUP] )* [0]
*
* char can be any character except 0 and TAB
* ESCGROUP is [0][Font][Color] ([-1])*
* (-1's are for padding)
*
* Font: 0:2 style, 3:6 fontnumber (upto MAXFONTS)
* Color: 0:2 foreground, 3:5 background
* [TAB] it's '\t'
*
*/

#define SKIPTOP 2
#define REFRESHSTATELEN 384
#define MAXFONTS 8
#define REFRESHCYCLES 2
#define FONTNUMBER(x) (((x)/8)%MAXFONTS)
#define STYLE(x) ((x)&7)
#define BACKGROUND(x) ((x)/8)
#define FOREGROUND(x) ((x)%8)
#define SPACEFORCOLROWNUMBERS 32
#define Even(x) ( (x) + (((int)(x))%2) )
#define SKIPCHAR (-1)
#define TABCHAR (9)
#define SEARCHSTRINGLENGTH 80
#define PAGEKEYLENGTH 40

#define OPT_COUNT 39

/*
*
* Macros for easy-to-read handling of lists
*
*/

#define FirstDisplayStatus(x) ((DisplayStatus *)((x)->mlh_Head))
#define IsEmpty(x) (!(x)->mlh_Head->mln_Succ)
#define IsNotEmpty(x) ((x)->mlh_Head->mln_Succ)
#define SuccDisplayStatus(x) ((DisplayStatus *)((x)->Node.mln_Succ))
#define PredDisplayStatus(x) ((DisplayStatus *)((x)->Node.mln_Pred))

/*
*
* Options
*
* These are user options, different for each window.
*
*/

#define SMOOTHSCROLLING	(1<<0)
#define LINENUMBERS		(1<<1)

/*
*
* Actions that can be taken---with menus, command lines or ARexx
*
*/

enum Actions { NOTHING,
					PAGE_UP, PAGE_DOWN, LINE_UP, LINE_DOWN, GO_TOP, GO_BOTTOM,
					PAGE_NEXT, PAGE_PREV, TLINE_CHANGED, MARGIN_RIGHT, MARGIN_LEFT,
					SCREEN_LEFT, SCREEN_RIGHT, CENTER_MARGIN,
					OPEN_WINDOW, CLOSE_WINDOW, CLOSE_ALL, FREE_ALL_FONTS,
					SIZE_WINDOW, REDISPLAY_WINDOW, REFRESH_WINDOW, REFRESH_LINES,
					OPEN_FILE, SAVE_ASCII, CHANGE_FONT, SELECT_WINDOW,
					SET_SMOOTH, SET_GROSSIER, NUMBERS_ON, NUMBERS_OFF, SET_SMART, SET_SIMPLE,
					SET_TAB_SIZE, SET_WORDWRAP, SET_LINE_SPACING, SET_PAGE_KEY,
					DO_SEARCH, SEARCH_AGAIN, SEARCH_AGAIN_BACK, WINDOW_TO_FRONT, SET_SIZE,
					ACTIONCOUNT };



typedef struct {
	char *Line;
	short Height;
	short Baseline;
	short Length;
	char Font, Color;
} LDesc;

typedef struct {
	struct MinNode Node;
	struct Window *Window;
	struct TextFont *FontTable[MAXFONTS+1];  /* FontTable[MAXFONTS] is always the system font */
	LDesc *Buffer, *TLine, *BLine, *OldTLine;
	char *FileBuffer;
	long FileBufferSize;
	struct Region *BorderRegion;
	char *Arg;
	short int TitleLen;
	short RC;
	short WindowPixLen;
	long PixLen;
	long LineLen;
	short WindowNumber;
	short BLinePixel;  /* from TLine */
	short LMargin;
	short WindowLines;
	char LineSpacing;
	char Options;
	char DoWipe;
	char DoRefresh;
	char DoMove;
	char KeepMove;
	short int TabSize;
	short int WordWrap;
	struct AllocRemember *RememberKey; /* tracks LineDesc & chars arrays */
	struct Gadget Gadget;
	struct PropInfo PropInfo;
	struct Image Image;
	char RefreshState[REFRESHSTATELEN];
	LDesc NullLineDesc[2];
	char StdTitle[4];
	char NullLine[4];
	char SearchString[SEARCHSTRINGLENGTH];
	char PageKey[PAGEKEYLENGTH];
} DisplayStatus;


struct MyMsg {
	struct Message ExecMsg;
	long Cmd;
	char Arg[4];   /* Extendible! */
};


#include "LeggiProtos.h"

extern struct IntuitionBase *IntuitionBase;
extern struct GfxBase *GfxBase;
extern struct Library *DiskfontBase;
extern struct ReqLib *ReqBase;
extern struct ArpBase *ArpBase;
extern struct Library *PPBase;
