/* AhOh.c -- This function is a user replaceable function whose
 *           purpose is to inform the WBench user/cli user that
 *           they do not have the correct version of ARP to run
 *           this program.
 *
 * If you replace this module, you *must* observe the following:
 *
 *      Only SysBase is valid, no DOSBase, IntuitionBase, or GfxBase
 *      (or ArpBase, of course), so if you call one of these libraries,
 *      you must open them first.
 *
 *      If you are a WBench baby, you must reply the WBench msg, this is passed
 *      to you as the single parameter.
 *
 *      The startup code exits immediately when this returns.
 *
 *
 * 17/1/90
 * No more management for DOS or WBenchMsg, now we are called from _main;
 * A little reworked to fit at best with Lattice 5.04
 *
 *                                                Sebastiano Vigna
 *
 * NOTE: This version (sv_tiny) is also as crunched as possible...
 */

#include <exec/types.h>
#include <exec/alerts.h>
#include <intuition/intuition.h>
#include <proto/intuition.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <string.h>

extern struct IntuitionBase *IntuitionBase;
extern struct WBStartup *WBenchMsg;

char NO_ARP_MSG[] = "You need arp.library v39+";
char NEWLINE[] = "\n";

/* Intuitext for WBench user */
struct IntuiText NO_ARP_REQUESTER = {
   AUTOFRONTPEN, AUTOBACKPEN, AUTODRAWMODE,
   20,20,                               /* Left top */
   AUTOITEXTFONT,                      /* FONT */
   NO_ARP_MSG,
};

struct IntuiText CANCEL = {
  AUTOFRONTPEN, AUTOBACKPEN, AUTODRAWMODE,
  AUTOLEFTEDGE, AUTOTOPEDGE,
  AUTOITEXTFONT,
  "Cancel",
  AUTONEXTTEXT,
};


void AhOhNoARP(void) {

  if ( !WBenchMsg ) {                 /* If from CLI... */
      Write(Output(), NO_ARP_MSG, strlen(NO_ARP_MSG));
		Write(Output(), NEWLINE, 1);
      return;
  }
                                      /* Else we are from workbench */
  if ( (IntuitionBase = OpenLibrary("intuition.library", 0L)) == NULL) {
      Alert(AG_OpenLib|AO_Intuition, 0L);
      return;
  }

  AutoRequest(0L, &NO_ARP_REQUESTER, NULL, &CANCEL, 0L, 0L, 320L, 72L);
  CloseLibrary(IntuitionBase);
}
