#include "Leggi.h"

#define SCREENLEN (sizeof(struct Screen))
#define ITEMCOUNT 23
#define MENUCOUNT 3
#define ITEMOFF (1<<7 | 1<<12 | 1<<19 | 1<<20 | 1<<21 || 1<<22)

static char MenuAction[ITEMCOUNT] = {	OPEN_WINDOW, OPEN_FILE, CLOSE_WINDOW,
													SAVE_ASCII, CLOSE_ALL, CHANGE_FONT, FREE_ALL_FONTS,
													DO_SEARCH, SEARCH_AGAIN, SEARCH_AGAIN_BACK,
													SELECT_WINDOW, REDISPLAY_WINDOW,
													TLINE_CHANGED, SET_SMOOTH, SET_GROSSIER,
													SET_SIMPLE, SET_SMART, NUMBERS_ON,
													NUMBERS_OFF, SET_TAB_SIZE, SET_WORDWRAP,
													SET_LINE_SPACING, SET_PAGE_KEY	};

static char ItemOffset[MENUCOUNT+1]={ 0, 5, 13, ITEMCOUNT };

static char *MenuTitle[MENUCOUNT] =
{
	"Project",
	"Commands",
	"Options"
};

static char *MenuText[ITEMCOUNT] =
{
	"New",
	"Open...",
	"Close",
	"Save as ASCII...",
	"Quit",

	"Change Font...",
	"Free All Fonts",
	"Find...",
	"Find Next",
	"Find Previous",
	"Select",
	"Refresh Window",
	"Jump To...",

	"Smooth Scrolling",
	"Grossier Scrolling",
	"Simple Refresh",
	"Smart Refresh",
	"Line Numbers On",
	"Line Numbers Off",
	"Set Tabs...",
	"Set Wordwrap...",
	"Set Line Spacing...",
	"Set Page Key..."
};

static char MenuChar[ITEMCOUNT]={	'Y', 'O', 'Q', 0, 'X', 'C', 0, 'F', 'N', 'P', 0,
												'R', 'J', 'H', 'G', 0, 0, '1', '0', 'T', 'W', 'L', 'K' };


/*
*
* CreateMenu()
*
* takes a pointer to a *Menu, and to a TextFont. It allocates
* and initializes correctly and dynamically a menu with the entries described
* in MenuText.
* MENUCOUNT and ITEMCOUNT are used as dimensions. A RememberKey is returned for
* further deallocation, or NULL is returned if no memory.
*
* NOTE: We know the MenuItems will be drawn with this font, but who knows about
* the menu bar?
*
*/


struct AllocRemember *CreateMenu(struct Menu **Menu) {

	int i, Width=0, MenuCount=1, t;
	struct MenuItem *MenuItem;
	struct AllocRemember *RememberKey = NULL;
	struct IntuiText *MenuIText;
	struct TextAttr *Font;
	char Screen[SCREENLEN];

	GetScreenData(Screen, SCREENLEN, WBENCHSCREEN, NULL);
	Font = ((struct Screen *)Screen)->Font;

	if ((*Menu = (void *)AllocRemember(&RememberKey, sizeof(struct Menu)*MENUCOUNT+sizeof(struct MenuItem)*ITEMCOUNT+sizeof(struct IntuiText)*ITEMCOUNT, MEMF_PUBLIC | MEMF_CLEAR)) == NULL) return(NULL);
	MenuItem = (void *)(*Menu+MENUCOUNT);
   MenuIText = (void *)(MenuItem+ITEMCOUNT);

	for(i=0; i<MENUCOUNT; i++) {
		(*Menu)[i].MenuName = MenuTitle[i];
		(*Menu)[i].Width = TextLength(&((struct Screen *)Screen)->RastPort, (*Menu)[i].MenuName, strlen((*Menu)[i].MenuName))+Font->ta_YSize*2;
		(*Menu)[i].LeftEdge = i==0 ? 0 : (*Menu)[i-1].LeftEdge+(*Menu)[i-1].Width;
		(*Menu)[i].Height = Font->ta_YSize+1;
		(*Menu)[i].FirstItem = MenuItem+ItemOffset[i];
		(*Menu)[i].Flags = MENUENABLED;
		(*Menu)[i].NextMenu = i==MENUCOUNT-1 ? NULL : &(*Menu)[i+1];
	}

	for(i=0; i<ITEMCOUNT; i++) {

		MenuIText[i].TopEdge = 1;
		MenuIText[i].LeftEdge = 3;
		MenuIText[i].DrawMode = JAM1;
		MenuIText[i].ITextFont = (struct TextAttr *)Font;
		MenuIText[i].IText = MenuText[i];

		MenuItem[i].NextItem = i==ItemOffset[MenuCount]-1 ? NULL : &MenuItem[i+1];
		MenuItem[i].TopEdge = (Font->ta_YSize + 2) * (i-ItemOffset[MenuCount-1]);
		MenuItem[i].Height = Font->ta_YSize+2;
		MenuItem[i].Flags = COMMSEQ*(MenuChar[i]!=0) | (!ReqBase && (ITEMOFF & (1<<i)) ? NULL : ITEMENABLED) | HIGHCOMP | ITEMTEXT;
		MenuItem[i].ItemFill = (APTR)&MenuIText[i];
		MenuItem[i].Command = MenuChar[i];

		if ((t = IntuiTextLength(&MenuIText[i])) > Width) Width = t;

		if (i==ItemOffset[MenuCount]-1) {
			for(t=ItemOffset[MenuCount-1]; t<ItemOffset[MenuCount]; t++)
				MenuItem[t].Width = Width+Font->ta_YSize*3+COMMWIDTH;
			Width = 0;
			MenuCount++;
		}
	}

	return(RememberKey);
}


/*
*
* ParseMenu()
*
* parses the menu message--returns the action.
*
*/

int ParseMenu(struct IntuiMessage *Message) {

	if (Message->Code==MENUNULL) return(NOTHING);

	return((int)MenuAction[ItemOffset[MENUNUM(Message->Code)]+ITEMNUM(Message->Code)]);
}
