#include "Leggi.h"

#define ESC 0x45
#define SPACE 0x40
#define LETTER_B 0x35
#define BACKSPACE 0x41

static char RexxCommands[][4] = {"bac", "for", "up", "do", "nex",
											"to", "bo", "ju", "le", "ri",
											"wr", "wl", "ce",
											"new", "cl", "qu",
											"wi", "op", "sa", "fon",
											"sel",  "sm", "gr", "non", "nof",
											"ta", "fi", "fne", "fpr", "re", "wo", "fr",
											"li", "wt", "ke", "si", "\0" };

static char RexxAction[] = { PAGE_UP, PAGE_DOWN, LINE_UP, LINE_DOWN, PAGE_NEXT,
										GO_TOP, GO_BOTTOM, TLINE_CHANGED, MARGIN_LEFT,
										MARGIN_RIGHT, SCREEN_LEFT, SCREEN_RIGHT,
										CENTER_MARGIN, OPEN_WINDOW, CLOSE_WINDOW, CLOSE_ALL,
										SIZE_WINDOW, OPEN_FILE, SAVE_ASCII, CHANGE_FONT,
										SELECT_WINDOW, SET_SMOOTH, SET_GROSSIER,
										NUMBERS_ON, NUMBERS_OFF, SET_TAB_SIZE, DO_SEARCH,
										SEARCH_AGAIN, SEARCH_AGAIN_BACK,
										REDISPLAY_WINDOW, SET_WORDWRAP, FREE_ALL_FONTS,
										SET_LINE_SPACING, WINDOW_TO_FRONT, SET_PAGE_KEY,
										SET_SIZE };


static char ShiftAction[4] = { PAGE_UP, PAGE_DOWN, SCREEN_RIGHT, SCREEN_LEFT };
static char AltAction[4] = { GO_TOP, GO_BOTTOM, CENTER_MARGIN, CENTER_MARGIN };
static char CtrlAction[4] = { PAGE_PREV, PAGE_NEXT, NOTHING, NOTHING };
static char AloneAction[4] = { LINE_UP, LINE_DOWN, MARGIN_RIGHT, MARGIN_LEFT };


/*
*
* ParseIDCMP()
*
* takes a Message pointer and a Display status pointer; it returns the correct
* action to take.
*
*/

int ParseIDCMP(struct IntuiMessage *Message, DisplayStatus *D) {

	LDesc *L;

	ArgClear(D);

	switch (Message->Class) {
		case RAWKEY:	if (Message->Code == ESC) return(CLOSE_WINDOW);
							if (Message->Code>0 && Message->Code<11) {
								if (ArgAlloc(D, 4)) SPrintf(D->Arg, "%ld", Message->Code+10*((Message->Qualifier & (IEQUALIFIER_LALT | IEQUALIFIER_RALT)) != 0)+20*((Message->Qualifier & (IEQUALIFIER_LSHIFT | IEQUALIFIER_RSHIFT)) != 0)+40*((Message->Qualifier & IEQUALIFIER_CONTROL) != 0));
								return(WINDOW_TO_FRONT);
							}
							D->PropInfo.Flags &= ~KNOBHIT;
							if (Message->Code>CURSORLEFT || Message->Code<CURSORUP)
								switch(Message->Code) {
									case BACKSPACE:
									case LETTER_B:
										return(PAGE_UP);
									case SPACE:
										return(PAGE_DOWN);
								}
							else if (Message->Qualifier & (IEQUALIFIER_LSHIFT | IEQUALIFIER_RSHIFT))
								return((int)ShiftAction[Message->Code-CURSORUP]);
							else if (Message->Qualifier & (IEQUALIFIER_LALT | IEQUALIFIER_RALT))
								return((int)AltAction[Message->Code-CURSORUP]);
							else if (Message->Qualifier & (IEQUALIFIER_CONTROL))
								return((int)CtrlAction[Message->Code-CURSORUP]);
							else D->DoMove = AloneAction[Message->Code-CURSORUP];
							break;

		case CLOSEWINDOW:	return(CLOSE_WINDOW);

		case NEWSIZE:	return(SIZE_WINDOW);

		case REFRESHWINDOW:	return(REFRESH_WINDOW);

		case MOUSEMOVE:
		case GADGETDOWN:
		case GADGETUP:	if ((D->Gadget.Flags & GADGDISABLED) ||
								((L = D->Buffer+(D->PropInfo.VertPot+1)*(ULONG)(D->LineLen-D->WindowLines)/(ULONG)MAXPOT) == D->TLine))
								return(NOTHING);

							if (!(D->PropInfo.Flags & KNOBHIT))
								if (L<D->TLine) return(PAGE_UP);
									else return(PAGE_DOWN);

							D->TLine = L;
							return(NOTHING);


		case MOUSEBUTTONS:	D->PropInfo.Flags &= ~KNOBHIT;
									switch(Message->Code) {
										case SELECTDOWN:	if (Message->MouseY < D->Window->Height/3) D->DoMove = LINE_UP;
																else if (Message->MouseY > (D->Window->Height*2)/3) D->DoMove = LINE_DOWN;
																else if (Message->MouseX < (D->Window->Width/8)) D->DoMove = MARGIN_LEFT;
																else if (Message->MouseX > (D->Window->Width*7)/8) D->DoMove = MARGIN_RIGHT;
																D->KeepMove = 1;
																break;

										case SELECTUP:		D->KeepMove = D->DoMove = 0;
									}
									break;

		case MENUPICK:	D->PropInfo.Flags &= ~KNOBHIT;
							return(ParseMenu(Message));

	}

	return(NOTHING);
}

/*
*
* cmdcmp()
*
* it's Tom's wonderful function for matching the *c command against the *m pattern
*
*/

char cmdcmp(char *c, char *m) {
   while (*c && ((*c == *m) || (*c == *m + 32 && ('a' <= *c && *c <= 'z')))) {
      c++ ;
      m++ ;
   }
   return(*c) ;
}

/*
*
* ParseARexx()
*
* takes an ARexxMessage pointer and a Display status pointer; it returns the correct
* action to take.
*
*/

int ParseARexx(struct RexxMsg *ARexxMessage, DisplayStatus *D) {

	register int i=0;
	register char *p;

	D->PropInfo.Flags &= ~KNOBHIT;
	ArgClear(D);

	do {
		if (!cmdcmp(RexxCommands[i], p = ARexxMessage->rm_Args[0])) {
			while(*(p++)>' ');
			ArgSet(D, p);
			return((int)RexxAction[i]);
		}
	} while(RexxCommands[++i][0]);

	return(NOTHING);
}
