#include "Leggi.h"

/*
*
* GetPixelValue()
*
* takes 2 pointer and returns the number of pixels between the 2 pointers.
*
*/

int GetPixelValue(LDesc *StartLineDesc, LDesc *EndLineDesc) {

	register int n = 0;

	while(StartLineDesc<EndLineDesc) n += (StartLineDesc++)->Height;
	return(n);
}


/*
*
* WindowPixLen()
*
* takes a window pointer and returns the real display area height (uses SKIPTOP).
*
*/

int WindowPixLen(struct Window *Window) {

	return(Window->Height - Window->BorderTop - Window->BorderBottom - SKIPTOP);

}

/*
*
* WindowPixWidth()
*
* takes a window pointer and returns the real display area width.
*
*/

int WindowPixWidth(struct Window *Window) {

	return(Window->Width - Window->BorderLeft - Window->BorderRight - 2);

}

/*
*
* WindowSkip()
*
* takes a DisplayStatus pointer and returns the skip for a screen left or right. Uses
* the default font width for the overlap area.
*
*/

int WindowSkip(DisplayStatus *D) {

	int t = D->FontTable[MAXFONTS]->tf_XSize;

	return((WindowPixWidth(D->Window)-t)/t*t);

}

/*
*
* GetPixelAddress()
*
* takes a Leggi's internal file pointer and a number of pixel and returns the
* line for which Sum[line heights] is greater than the given number.
*
*/

LDesc *GetPixelAddress(LDesc *LineDesc, int n) {

	register int len = 0;

	do
		if ((len += LineDesc->Height)>n) break;
	while((++LineDesc)->Line);

	return(LineDesc);
}


/*
*
* GetPixelAddressBack()
*
* like GetPixelAddress, but backward. A pointer to the start of the buffer is
* of course required,
*
*/

LDesc *GetPixelAddressBack(LDesc *LineDesc, LDesc *Buffer, int n) {

	while(LineDesc != Buffer)
		if ((n -= (--LineDesc)->Height)<0) break;

	return(LineDesc);
}


/*
*
* SetPropGadget()
*
* takes a DisplayStatus pointer and sets the VertBody
* and VertPot. If the document is too small, offs the gadget.
*
*/

void SetPropGadget(DisplayStatus *D) {

	if (D->LineLen>D->WindowLines) {
		if (D->Gadget.Flags & GADGDISABLED) OnGadget(&D->Gadget, D->Window, NULL);
		NewModifyProp(&D->Gadget, D->Window, NULL, D->PropInfo.Flags, -1, D->BLine->Line ? ((ULONG)(MAXPOT)*(D->TLine-D->Buffer))/(ULONG)(D->LineLen-D->WindowLines) : -1, -1, ((ULONG)MAXBODY*(ULONG)D->WindowPixLen)/(D->PixLen), 1);
	}
	else {
		OffGadget(&D->Gadget, D->Window, NULL);
		NewModifyProp(&D->Gadget, D->Window, NULL, D->PropInfo.Flags, -1, -1, -1, -1, 1);
	}
}


/*
*
* Bottom()
*
* returns the TLine for the Bottom page of the given DisplayStatus
*
*/

LDesc *Bottom(DisplayStatus *D) {

	LDesc *L = D->Buffer+D->LineLen;

	return(GetPixelAddressBack(L, D->Buffer, D->WindowPixLen)+1);
}

/*
*
*
* PageForward()
*
* finds the new TLine for a page forward.
*
*/

LDesc *PageForward(DisplayStatus *D) {

	LDesc *L;

	L = FindBottomLine(D, D->BLine-(D->BLine>D->Buffer));
	if (L->Line) return(D->BLine-1);
	else return(Bottom(D));
}

/*
*
*
* PageBackward()
*
* finds the new TLine for a page backward.
*
*/

LDesc *PageBackward(DisplayStatus *D) {

	return(GetPixelAddressBack(D->TLine+1, D->Buffer, D->WindowPixLen-(D->TLine+1)->Height));
}

