#include "Leggi.h"

/*
*
* Search()
*
* takes a pointer to a DisplayStatus. Searches for the string in the Arg, starting
* from the current TLine, moving towards Direction and returning the first
* LineDesc with a match or NULL if no match is found.
*
*/

unsigned char __asm tolower( register __d0 unsigned char);

static char d[256];

LDesc *Search(DisplayStatus *D, unsigned char *String, int Direction) {

	register unsigned char *p, *q, *s, c;
	register int i,m;
	LDesc *L;

	L = D->TLine;
	if (!(m = strlen(String))) return(NULL);

	if (!(s = ArpAlloc(m+1))) return(NULL);
	strcpy(s, String);
	memset(d, 0, 256);
	for(i=0; i<m; i++) s[i] = tolower(s[i]);
	for(i=0; i<m-1; i++) d[s[i]] = m-i-1;
	d[s[m-1]] = -1;

	L+=Direction;

	while((p = L->Line) && (L >= D->Buffer)) {
		while(p - L->Line < L->Length) {
			q = p + strlen(p);
			p+=m-1;

			while(p < q)
				if (!d[c = tolower(*p)]) p+=m;
				else if (d[c]>0) p+=d[c];
				else {
					for (i=1; i<m; i++)
						if (tolower(*(p-i)) != s[m-i-1]) {
							p++;
							break;
						}
					if (i == m) {
						FreeTrackedItem((void *)s);
						return(L);
					}
				}

			p = (char *)skipneg(q+3);
		}

		L+=Direction;
	}

	FreeTrackedItem((void *)s);
	DisplayBeep(NULL);
	D->RC = 1;
	return(NULL);
}
