#include "M.h"
#include <clib/pchglib_protos.h>
#include <math.h>

#define IS_PCHG (GroupData->FilledField[3])
#define IS_SHAM (GroupData->SHAMSize)

#define LACECORR(x)  ((((x) & LACE) != 0)+1)
#define HIRESCORR(x)  ((((x) & HIRES) != 0)+1)

#define WordPadByteNum(x) (  ( ((x)/16) + (((x)%16)!=0) ) *2)

#define x320x200Aspect 10
#define y320x200Aspect 11
#define x320x400Aspect 20
#define y320x400Aspect 11
#define x640x200Aspect  5
#define y640x200Aspect 11
#define x640x400Aspect 10
#define y640x400Aspect 11
#define x320x256Aspect  6
#define y320x256Aspect  7
#define x320x512Aspect 12
#define y320x512Aspect  7
#define x640x256Aspect  3
#define y640x256Aspect  7
#define x640x512Aspect  6
#define y640x512Aspect  7

extern char **argv, NewOS, NewerOS;
extern struct ExtNewScreen *NewScreen;
extern struct NewWindow *NewWindow;
extern struct timerequest *timereq;
extern struct MsgPort *Port;
extern struct timerequest *RangeReq;

void __stdargs UnPack(	ULONG StartX, ULONG EndX, ULONG NumY, char *n, char **p,	ULONG PicX,
								ULONG StartYByte, USHORT *Mask, ULONG BitPlaneNumber);

void UpScreen(struct Screen *Screen);
BOOL CheckAll(void);
void CondKillMouse(struct Window *Window);
void CondBlackUp(void);
void CondFreeScreen(struct Screen *Screen);

struct Screen *DBScreen;
struct Window *DBWindow;
char ActiveRange[8];

static struct TagItem ScreenTags[] = { { SA_DClip, NULL }, { SA_DisplayID, NULL }, { TAG_DONE } };

void PostRangeReq(int RangeN, short rate) {

	RangeReq[RangeN].tr_node.io_Error = 0;
	RangeReq[RangeN].tr_time.tv_micro = ((16667*16384)/rate)%1000000;
	RangeReq[RangeN].tr_time.tv_secs = ((16667*16384)/rate)/1000000;
	SendIO((struct IORequest *)&RangeReq[RangeN]);
}

void AbortPendingTimeReq(struct timerequest *req) {

	AbortIO((struct IORequest *)req);
	WaitIO((struct IORequest *)req);
}

void AbortAllRangeReq(void) {
	int i;
	for(i=0; i<8; i++) if (ActiveRange[i]) AbortPendingTimeReq(&RangeReq[i]);
}

void StartAllRangeReq(GroupData *GroupData) {
	int i;
	for(i=0; i<8; i++) if (ActiveRange[i]) PostRangeReq(i, GroupData->Range[i].rate);
}


BOOL Display(GroupData *GroupData, int File, int ChunkLen) {

	char *Planes[8], *m, *PCHGDecomp = NULL, CanScroll;
	int OldPri;
	struct PCHGCompHeader *pch = NULL;
	unsigned char *col;
	BitMapHeader *IFFBMH;
	short	Mask;
	long	y, ByteSWidth, i, j, t, ByteIFFWidth, CycleActive = 0,
			RealByteWidth, RealHeight, RightWidth, RightHeight,
			TopWidth, TopHeight, coln=0, f = 0, SkipRepeat, XOrigin=0, YOrigin=0, Tx=0, Ty=0;
	USHORT *table=NULL;
	ULONG Signals, WaitMask, *table32 = NULL, t32[3];
	struct Screen *Screen;
	struct Window *Window;
	struct IntuiMessage *Message;
	struct timerequest *CycleMessage;
	BOOL RC = OK, ChangedPriority = FALSE;
	struct View View;
	struct Rectangle Rect, MaxRect;


	InitView(&View);
	if (GroupData->FilledField[0] == 0) return(ERROR);

	IFFBMH = &GroupData->BitMapHeader;
	NewScreen->ViewModes=0;
	ChunkLen += ChunkLen%2;

	if (GroupData->FilledField[1]) {
		col  = GroupData->CMAP;
		coln = GroupData->CMAP_Len;
	}

	if ((!(GroupData->CAMG & MONITOR_ID_MASK)) ||
			((GroupData->CAMG & EXTENDED_MODE) && (!(GroupData->CAMG & 0xFFFF0000))))
				GroupData->CAMG &= ~(SPRITES | VP_HIDE | GENLOCK_AUDIO | GENLOCK_VIDEO);

	if ((GroupData->CAMG & 0xFFFF0000) && (!(GroupData->CAMG & EXTENDED_MODE)))
		GroupData->CAMG &= (~(SPRITES | VP_HIDE | GENLOCK_AUDIO | GENLOCK_VIDEO) & 0xFFFF);

	memset(ActiveRange, 0, 8);

	if (coln)
		for(i=0; i<8; i++) {
			GroupData->Range[i].high %= coln/3;
			GroupData->Range[i].low %= coln/3;
			ActiveRange[i] = (((GroupData->Range[i].rate>36) || (GroupData->Range[i].flags & 1)) && ((USHORT)GroupData->Range[i].rate<=16384) && (GroupData->Range[i].rate) && (GroupData->Range[i].high > GroupData->Range[i].low));
		}

	if ((m = AllocMem(ChunkLen, MEMF_PUBLIC | MEMF_CLEAR)) == NULL) {
		Puts("Not enough memory to load file");
		return(OK);
	}

	if (coln) {
		if ((table = (void *)AllocMem((coln/3)*2, MEMF_PUBLIC | MEMF_CLEAR)) == NULL) {
			Puts("Not enough memory for color table");
			RC = MEMORY;
			goto ExitFreeing;
		}
	}


	if (Read(File, m, ChunkLen) < ChunkLen) {
		RC = ERROR;
		goto ExitFreeing;
	}

	if (RC = CheckAll()) goto ExitFreeing;

	if ((NewScreen->Depth = IFFBMH->nPlanes)>6 && !NewerOS) {
		Puts("Too many bitplanes");
		goto ExitFreeing;
	}

	if (NewScreen->Depth == 0) {
		Puts("No bitplanes");
		goto ExitFreeing;
	}

	if ASKED(OPT_HIRES) GroupData->CAMG |= HIRES;
	if ASKED(OPT_LACE) GroupData->CAMG |= LACE;

	if ASKED(OPT_HAM) {
		GroupData->CAMG |= HAM;
		GroupData->CAMG &= ~EXTRA_HALFBRITE;
	}

	if ASKED(OPT_HALFBRITE) {
		GroupData->CAMG |= EXTRA_HALFBRITE;
		GroupData->CAMG &= ~HAM;
	}

	if (	(IFFBMH->w == 640) && (IFFBMH->nPlanes < 5) && ((IFFBMH->h == 256) || (IFFBMH->h == 200))	)
		GroupData->CAMG |= HIRES;
	else if (	(IFFBMH->w == 640) && (IFFBMH->nPlanes < 5) && ((IFFBMH->h == 512) || (IFFBMH->h == 400))	)
		GroupData->CAMG |= HIRES | LACE;
	else if (	((IFFBMH->xAspect == x320x400Aspect) && (IFFBMH->yAspect == y320x400Aspect)) || ((IFFBMH->xAspect == x320x512Aspect) && (IFFBMH->yAspect == y320x512Aspect)) )
		GroupData->CAMG |= LACE;
	else if (	((IFFBMH->xAspect == x640x200Aspect) && (IFFBMH->yAspect == y640x200Aspect)) || ((IFFBMH->xAspect == x640x256Aspect) && (IFFBMH->yAspect == y640x256Aspect)) )
			GroupData->CAMG |= HIRES;

	if ASKED(OPT_LORES) GroupData->CAMG &= ~HIRES;
	if ASKED(OPT_NOLACE) GroupData->CAMG &= ~LACE;

	if (NewOS) {
		if (!QueryOverscan(GroupData->CAMG, &Rect, OSCAN_TEXT)) {
			GroupData->CAMG &= 0xFFFF;
			if (!QueryOverscan(GroupData->CAMG, &Rect, OSCAN_TEXT)) {
				Printf("\tCan't open monitor");
				goto ExitFreeing;
			}
		}
		RightWidth = Rect.MaxX-Rect.MinX+1;
		RightHeight = Rect.MaxY-Rect.MinY+1;
		if (!QueryOverscan(GroupData->CAMG, &MaxRect, OSCAN_MAX)) {
			Printf("\tCan't open monitor");
			goto ExitFreeing;
		}
		TopWidth = MaxRect.MaxX-MaxRect.MinX+1;
		TopHeight = MaxRect.MaxY-MaxRect.MinY+1;
		NewScreen->Type |= NS_EXTENDED;
		NewScreen->Extension = ScreenTags;
		ScreenTags[0].ti_Data = (ULONG)&Rect;
		ScreenTags[1].ti_Data = GroupData->CAMG;
	}
	else {
		RightWidth = GfxBase->NormalDisplayColumns/2;
		RightHeight = GfxBase->NormalDisplayRows;

		TopWidth = 362;
		if (GfxBase->DisplayFlags & PAL) TopHeight = 283;
		else TopHeight = 241;

		if (GroupData->CAMG & HIRES) {
			RightWidth *= 2;
			TopWidth = 704;
		}

		if (GroupData->CAMG & LACE) {
			RightHeight *= 2;
			TopHeight *= 2;
		}
	}

	if (IFFBMH->w <= TopWidth && (ASKED(OPT_CENTER) || IFFBMH->w<=RightWidth)) NewScreen->Width = (IFFBMH->w<256 ? 256 : IFFBMH->w);
		else NewScreen->Width = RightWidth;

	if (IFFBMH->h <= TopHeight && (ASKED(OPT_CENTER) || IFFBMH->h<=RightHeight)) NewScreen->Height = (IFFBMH->h<128 ? 128 : IFFBMH->h);
		else NewScreen->Height = RightHeight;

   if ASKED(OPT_WIDTH) NewScreen->Width = (LONG)(argv[OPT_WIDTH])-1;
   if ASKED(OPT_HEIGHT) NewScreen->Height = (LONG)(argv[OPT_HEIGHT])-1;

	ByteIFFWidth = WordPadByteNum(IFFBMH->w);

	RealHeight=(NewScreen->Height>IFFBMH->h ? IFFBMH->h : NewScreen->Height);

	if (!ASKED(OPT_QUIET)) Printf("\nPic: %ldx%ld  Scr: %ldx%ld  Dpt: %ld", IFFBMH->w, IFFBMH->h, NewScreen->Width, NewScreen->Height, NewScreen->Depth);

	NewScreen->ViewModes = GroupData->CAMG & 0xFFFF;

	if (ASKED(OPT_CENTER) && NewOS) {
		Rect.MinX += (RightWidth-NewScreen->Width)/2;
		Rect.MinY += (RightHeight-NewScreen->Height)/2;
		if (Rect.MinX < MaxRect.MinX) Rect.MinX = MaxRect.MinX;
		if (Rect.MinY < MaxRect.MinY) Rect.MinY = MaxRect.MinY;
		if ((GroupData->CAMG & LACE) &&  (Rect.MinY % 2)) Rect.MinY++;
		Rect.MaxX = Rect.MinX+NewScreen->Width-1;
		Rect.MaxY = Rect.MinY+NewScreen->Height-1;
		if (Rect.MaxX > MaxRect.MaxX) Rect.MaxX = MaxRect.MaxX;
		if (Rect.MaxY > MaxRect.MaxY) Rect.MaxY = MaxRect.MaxY;
		NewScreen->LeftEdge = Rect.MinX;
		NewScreen->TopEdge = Rect.MinY;
	}

	if ((Screen = OpenScreen(NewScreen)) == NULL) {
		Puts("\tCan't open Screen");
		goto ExitFreeing;
	}

	SetRGB4(&(Screen->ViewPort), 0, 0, 0, 0);

	if (NewerOS && (table32 = AllocVec(8+3*4*max(coln/3, Screen->ViewPort.ColorMap->Count), MEMF_PUBLIC | MEMF_CLEAR)) == NULL) {
		Puts("Not enough memory for color table");
		RC = MEMORY;
		goto ExitFreeingScreen;
	}

	ByteSWidth = Screen->RastPort.BitMap->BytesPerRow;
	RealByteWidth=(ByteSWidth>ByteIFFWidth ? ByteIFFWidth : ByteSWidth);
	CanScroll = (ByteSWidth<ByteIFFWidth || NewScreen->Height<IFFBMH->h) && !ASKED(OPT_SECS) && !ASKED(OPT_LOCKPIC);

	NewWindow->Screen = Screen;
	NewWindow->Width = Screen->Width;
	NewWindow->Height = Screen->Height;

	if ((Window = OpenWindow(NewWindow)) == NULL) {
		RC = MEMORY;
		goto ExitFreeingScreen;
	}

	if (ASKED(OPT_CENTER) && !NewOS) {
		t = LockIBase(0);
		i = -(36+IntuitionBase->ViewLord.DxOffset-View.DxOffset)*HIRESCORR(GroupData->CAMG);
		j = -(((GfxBase->DisplayFlags & PAL) ? 15 : 23)+IntuitionBase->ViewLord.DyOffset-View.DyOffset)*LACECORR(GroupData->CAMG);
		UnlockIBase(t);
		if ((t = (RightWidth-NewScreen->Width)/2)<i) t = i;
		Screen->ViewPort.DxOffset += t;
		if ((t = (RightHeight-NewScreen->Height)/2)<j) t = j;
		if ((GroupData->CAMG & LACE) &&  (t % 2)) t++;
		Screen->ViewPort.DyOffset += t;
		MakeScreen(Screen);
		RethinkDisplay();
	}


	if (ASKED(OPT_FADE) && (GroupData->CAMG & HAM)) Printf("\nCan't fade HAM pictures!");

	if (!(ASKED(OPT_NOFASTDRAW)) && (OldPri = FindTask(NULL)->tc_Node.ln_Pri)<1) {
		SetTaskPri(FindTask(NULL), 1);
		ChangedPriority = TRUE;
	}

	if (coln) {
		if ( (!ASKED(OPT_FADE)) || (GroupData->CAMG & HAM) ) {
			for(i=0; i<coln; i+=3) table[i/3] = (col[i] & 0xf0) << 4 | col[i+1] & 0xf0 | col[i+2] >> 4;
			LoadRGB4(&(Screen->ViewPort), table, coln/3);
		}
		else LoadRGB4(&(Screen->ViewPort), table, coln/3);
	}

	CondKillMouse(Window);


	if (IS_SHAM && (pch = (void *)PCHG_SHAM2PCHG((UWORD *)GroupData->PCHG, GroupData->SHAMSize, GroupData->FilledField[2] && (GroupData->CAMG & LACE) ? 2 : 1))) {
		PCHG_SetUserCopList(0, 0, &Screen->ViewPort, (void *)pch, &((struct PCHGHeader *)pch)[1], (ULONG *)GroupData->PCHG);
		MakeScreen(Screen);
		RethinkDisplay();
	}

	if IS_PCHG {
		if (GroupData->PCHG->Compression == PCHG_COMP_HUFFMANN) {
			pch = (void *)&GroupData->PCHG[1];
			if (PCHGDecomp = AllocMem(pch->OriginalDataSize, MEMF_PUBLIC | MEMF_CLEAR))
				PCHG_FastDecomp((char *)&pch[1]+pch->CompInfoSize, PCHGDecomp, (WORD *)((char *)&pch[1]+pch->CompInfoSize-2), pch->OriginalDataSize);
			else GroupData->PCHG = NULL;
		}
		else if (GroupData->PCHG->Compression != PCHG_COMP_NONE) GroupData->PCHG = NULL;
		else PCHGDecomp = (void *)&GroupData->PCHG[1];
		if (GroupData->PCHG) {
			PCHG_SetUserCopList(0, 0, &Screen->ViewPort, GroupData->PCHG, PCHGDecomp, (ULONG *)PCHGDecomp+(GroupData->PCHG->LineCount+31)/32);
			MakeScreen(Screen);
			RethinkDisplay();
		}
	}

	for(i=0; i<IFFBMH->nPlanes; i++)
		Planes[i] = (char *)(Screen->BitMap.Planes[i])+ (ASKED(OPT_CENTER) != 0)*(((ByteSWidth - RealByteWidth)/2) +	((NewScreen->Height-RealHeight)/2)*ByteSWidth);

	Mask = ((IFFBMH->masking & mskHasMask) != 0);


	if (IFFBMH->compression == cmpByteRun1)
		UnPack(0, RealByteWidth, (ULONG)(RealHeight) | ((USHORT)(ByteSWidth-RealByteWidth) << 16), m, Planes, ByteIFFWidth, 0, &Mask, IFFBMH->nPlanes*4);

	else	if (IFFBMH->compression == cmpNone)
				for(y=0; y<RealHeight; y++)
					for(i=0; i<IFFBMH->nPlanes; i++)
						memcpy(Planes[i]+y*ByteSWidth, m+(y*(IFFBMH->nPlanes+Mask)+i)*ByteIFFWidth, RealByteWidth);
	else {
		Printf("\tCompression algorithm unknown\n");
		RC = ERROR;
		goto ExitFreeingScreen;
	}

	if (!CanScroll) {
		FreeMem(m, ChunkLen);
		m = NULL;
	}

	if (RC = CheckAll()) goto ExitFreeingScreen;

	if (ASKED(OPT_BLACKBACKG) || ASKED(OPT_DOUBLEBUFFERING)) UpScreen(Screen);

	if ASKED(OPT_DOUBLEBUFFERING) {
		CondFreeScreen(DBScreen);
		DBScreen = Screen;
		DBWindow = Window;
		UpScreen(Screen);
	}

	if (coln)
		if (ASKED(OPT_FADE) && (!(GroupData->CAMG & HAM)))
			for(j=0; j<17; j++) {
				for(i=0; i<coln; i+=3) table[i/3] = ((j*col[i])/16 & 0xf0) << 4 | (j*col[i+1])/16 & 0xf0 | (j*col[i+2])/16 >> 4;
				LoadRGB4(&(Screen->ViewPort), table, coln/3);
				if ((LONG)argv[OPT_FADE]-2) Delay((LONG)argv[OPT_FADE]-2);
			}

	if (NewerOS) {
		table32[0] = min(Screen->ViewPort.ColorMap->Count, coln/3) << 16;
		for(i=0; i<coln && i/3<Screen->ViewPort.ColorMap->Count; i+=3)
			for(j=0; j<3; j++)
				table32[1+i+j] = col[i+j]|(col[i+j]<<8)|(col[i+j]<<16)|(col[i+j]<<24);

		LoadRGB32(&Screen->ViewPort,table32);
	}

	if (ASKED(OPT_SECS)>1) {
		timereq->tr_node.io_Error = timereq->tr_time.tv_micro = 0;
		timereq->tr_time.tv_secs = ASKED(OPT_SECS)-1;
		SendIO((struct IORequest *)timereq);
	}

	if ASKED(OPT_CYCLE) {
		StartAllRangeReq(GroupData);
		CycleActive = 1;
	}

	WaitMask = (1 << Window->UserPort->mp_SigBit) | (1 << Port->mp_SigBit);

	if (ASKED(OPT_SECS) != 1)
	do {
		Signals = Wait(WaitMask);
		SkipRepeat = 0;
		if (Signals & (1 << Port->mp_SigBit))
			while (CycleMessage = (struct timerequest *)GetMsg(Port)) {

				if (CycleMessage == timereq) {
					f = 1;
					break;
				}
				if (GroupData->Range[i = CycleMessage-RangeReq].flags & 2) {
					if (NewerOS) {
						movmem(&table32[GroupData->Range[i].low*3+1], t32, 3*sizeof(ULONG));
						movmem(&table32[GroupData->Range[i].low*3+1+3], &table32[GroupData->Range[i].low*3+1], (GroupData->Range[i].high-GroupData->Range[i].low)*3*sizeof(ULONG));
						movmem(t32, &table32[GroupData->Range[i].high*3+1], 3*sizeof(ULONG));
					}
					else {
						t = table[GroupData->Range[i].low];
						movmem(&table[GroupData->Range[i].low+1], &table[GroupData->Range[i].low], (GroupData->Range[i].high-GroupData->Range[i].low)*2);
						table[GroupData->Range[i].high] = t;
					}
				}
				else {
					if (NewerOS) {
						movmem(&table32[GroupData->Range[i].high*3+1], t32, 3*sizeof(ULONG));
						movmem(&table32[GroupData->Range[i].low*3+1], &table32[GroupData->Range[i].low*3+1+3], (GroupData->Range[i].high-GroupData->Range[i].low)*3*sizeof(ULONG));
						movmem(t32, &table32[GroupData->Range[i].low*3+1], 3*sizeof(ULONG));
					}
					else {
						t = table[GroupData->Range[i].high];
						movmem(&table[GroupData->Range[i].low], &table[GroupData->Range[i].low+1], (GroupData->Range[i].high-GroupData->Range[i].low)*2);
						table[GroupData->Range[i].low] = t;
					}
				}
				if (NewerOS) LoadRGB32(&(Screen->ViewPort), table32);
				else LoadRGB4(&(Screen->ViewPort), table, coln/3);
				PostRangeReq(i, GroupData->Range[i].rate);
			}

		if (Signals & (1 << Window->UserPort->mp_SigBit))
			while (Message = (struct IntuiMessage *)GetMsg(Window->UserPort)) {
				if (!((SkipRepeat) && (Message->Qualifier & IEQUALIFIER_REPEAT)))
					switch(Message->Class) {
						case MOUSEBUTTONS:	f = ((Message->Code == MENUUP) && (Message->MouseY == 0)) || ASKED(OPT_FREEMOUSE);
													break;
						case RAWKEY:			if ASKED(OPT_LOCKKEYS) break;
													if (Message->Qualifier & IEQUALIFIER_REPEAT) SkipRepeat = 1;
													switch (Message->Qualifier & (MY_QUALIFIERS)) {
														case IEQUALIFIER_LALT:
														case IEQUALIFIER_RALT:
															i = (1<<24);
															break;
														case IEQUALIFIER_LSHIFT:
														case IEQUALIFIER_RSHIFT:
															if (Message->Code == CURSORUP || Message->Code == CURSORDOWN) {
																if ((i = Screen->Height-16)<0) i = 0;
															}
															else if (Message->Code == CURSORLEFT || Message->Code == CURSORRIGHT) {
																if ((i = Screen->Width-16)<0) i = 0;
															}
															break;
														case IEQUALIFIER_CONTROL:
															i = 16;
															break;
														default:
															i = 8;
															break;
													}

													switch (Message->Code) {
														case CURSORUP:
															if ((YOrigin -= i) < 0) YOrigin = 0;
															if ((YOrigin%2) && (IS_PCHG || IS_SHAM)) YOrigin--;
															break;
														case CURSORDOWN:
															if (IFFBMH->h-(YOrigin += i) < NewScreen->Height) YOrigin = IFFBMH->h-RealHeight;
															if ((YOrigin%2) && (IS_PCHG || IS_SHAM)) YOrigin--;
															break;
														case CURSORLEFT:
															if ((XOrigin -= i) < 0) XOrigin = 0;
															break;
														case CURSORRIGHT:
															if (ByteIFFWidth*8-(XOrigin += i) < ByteSWidth*8) XOrigin = (ByteIFFWidth-RealByteWidth)*8;
															break;
														case 0x42:
															if (CycleActive) AbortAllRangeReq();
															else StartAllRangeReq(GroupData);
															CycleActive = !CycleActive;
															i=0;
															break;
														case 0x33:
															if (i == 16) {
																RC = BREAK;
																f = 1;
																i = 0;
															}
															break;
														case 0x40:
														case 0x44:
														case 0x45:
															f = 1;
														default:
															i = 0;
															break;
													}
													if (CanScroll && (i) && ((XOrigin != Tx) || (YOrigin != Ty))) {
														if (IS_PCHG && GroupData->PCHG && (YOrigin != Ty)) {
															if (coln) {
																if (NewerOS) LoadRGB32(&(Screen->ViewPort), table32);
																else LoadRGB4(&(Screen->ViewPort), table, coln/3);
															}
															PCHG_SetUserCopList(YOrigin, RealHeight, &Screen->ViewPort, GroupData->PCHG, PCHGDecomp, (ULONG *)PCHGDecomp+(GroupData->PCHG->LineCount+31)/32);
															MakeScreen(Screen);
															RethinkDisplay();
														}
														if (IS_SHAM && pch && (YOrigin != Ty)) {
															if (coln) {
																if (NewerOS) LoadRGB32(&(Screen->ViewPort), table32);
																else LoadRGB4(&(Screen->ViewPort), table, coln/3);
															}
															PCHG_SetUserCopList(YOrigin, RealHeight, &Screen->ViewPort, (void *)pch, &((struct PCHGHeader *)pch)[1], (ULONG *)GroupData->PCHG);
															MakeScreen(Screen);
															RethinkDisplay();
														}
														Tx = XOrigin; Ty = YOrigin;
														for(i=0; i<IFFBMH->nPlanes; i++)
															Planes[i] = (char *)(Screen->BitMap.Planes[i])+ (ASKED(OPT_CENTER) != 0)*(((ByteSWidth - RealByteWidth)/2) + ((NewScreen->Height-RealHeight)/2)*ByteSWidth);
														if (IFFBMH->compression == cmpByteRun1)
															UnPack((LONG)(XOrigin/8), RealByteWidth, (ULONG)(RealHeight) | ((USHORT)(ByteSWidth-RealByteWidth) << 16), m, Planes,
																		ByteIFFWidth, (LONG)YOrigin*(LONG)ByteIFFWidth*(IFFBMH->nPlanes+Mask), &Mask, IFFBMH->nPlanes*4);
														else if (IFFBMH->compression == cmpNone)
															for(y=0; y<RealHeight; y++)
																for(i=0; i<IFFBMH->nPlanes; i++)
																	memcpy(Planes[i]+y*ByteSWidth, m+((y+YOrigin)*(IFFBMH->nPlanes+Mask)+i)*ByteIFFWidth+XOrigin/8, RealByteWidth);
													}
													break;
						default:					break;
					}
				ReplyMsg((struct Message *)Message);
			}
	} while(!(f));

	if (ASKED(OPT_SECS)>1) AbortPendingTimeReq(timereq);
	if (CycleActive) AbortAllRangeReq();

	if (coln)
		if (ASKED(OPT_FADE) && (!(GroupData->CAMG & HAM)))
			for(j=16; j>=0; j--) {
				for(i=0; i<coln; i+=3) table[i/3] = ((j*col[i])/16 & 0xf0) << 4 | (j*col[i+1])/16 & 0xf0 | (j*col[i+2])/16 >> 4;
				LoadRGB4(&(Screen->ViewPort), table, coln/3);
				if ((LONG)argv[OPT_FADE]-2) Delay((LONG)argv[OPT_FADE]-2);
			}

ExitFreeingScreen:

	if (ChangedPriority) SetTaskPri(FindTask(NULL), OldPri);
	CondBlackUp();
	if (DBScreen != Screen) CondFreeScreen(Screen);

ExitFreeing:

	if (m) FreeMem(m, ChunkLen);
	if (table) FreeMem(table, (coln/3)*2);
	if (NewerOS) FreeVec(table32);
	if (IS_PCHG && GroupData->PCHG && GroupData->PCHG->Compression == PCHG_COMP_HUFFMANN && PCHGDecomp) FreeMem(PCHGDecomp, pch->OriginalDataSize);
	if (IS_SHAM && pch) FreeMem(pch, sizeof(struct PCHGHeader)+((((struct PCHGHeader *)pch)->LineCount+31)/32)*4);
	return(RC);
}
