#include "M.h"

#pragma  libcall	ArpBase	ArpOpenLibrary		028E	0902

BOOL ReadIFFFile(char *FileName);
BOOL CheatGo(char *Sel, int l, char **StartupArgs);

struct UserAnchor {
	struct AnchorPath ua_AP;
	BYTE paths[512];
};

char *CLI_Template="Files/...,A=All/S,R=Repeat/S,Q=Quiet/S,NoFastDraw/S,\
C=Center/S,B=BlackBackground/S,W=Width/K,H=Height/K,Cycle/S,\
Secs/K,Fade/K,NO=NoStartup/S,Batch/K,LockPic/S,\
N=NoMouse/S,F=FreeMouse/S,LockKeys/S,NA=NoActivate/S,DB=DoubleBuffering/S,\
Hires/S,Lace/S,Lores/S,NoLace/S,HAM/S,Halfbrite/S";

char *CLI_Help="[1m[33mMostra[m 1.09  1990,1991,1992 Sebastiano Vigna\n\
Usage: M <wildcards [...] | !> [All] [Repeat] [Quiet] [NoFastDraw]\
\n\t[Center] [BlackBackground] [Width n] [Height n] [Cycle]\
\n\t[Secs time] [Fade speed] [NoStartup] [Batch file] [LockPic]\
\n\t[NoMouse] [FreeMouse] [LockKeys] [NoActivate] [DoubleBuffering]\
\n\t[Hires | Lores] [Lace | NoLace] [HAM | Halfbrite]\n";

char *StartupFiles[2]={	"S:Startup-Mostra", "" };
char **argv, NewOS, NewerOS;
USHORT *SpriteData;
struct timerequest *timereq;
struct timerequest *RangeReq;

struct Screen *BlackScreen = NULL;
struct Window *BlackWindow = NULL;
struct ExtNewScreen *NewScreen;
struct NewWindow *NewWindow;
struct MsgPort *Port;

struct Library *IconBase;
struct IntuitionBase *IntuitionBase;
struct GfxBase *GfxBase;

extern struct WBStartup *WBenchMsg;
extern struct Screen *DBScreen;
extern struct Window *DBWindow;

void CondKillMouse(struct Window *Window) {
	if ASKED(OPT_NOMOUSE) SetPointer(Window, SpriteData, 0, 0, 0, 0);
}

BOOL CheckWindow(struct Window *Window) {

	struct IntuiMessage *Message;
	BOOL ReturnCode = FALSE;

	while (Message = (struct IntuiMessage *)GetMsg(Window->UserPort)) {
		if ((Message->Class == RAWKEY) && ((Message->Qualifier & MY_QUALIFIERS) == IEQUALIFIER_CONTROL) && (Message->Code == 0x33)) ReturnCode = TRUE;
		ReplyMsg((struct Message *)Message);
	}

	return(ReturnCode);
}

BOOL CheckAll(void) {
	return((BOOL)(((CheckAbort(NULL)) ||
			((BlackWindow) && CheckWindow(BlackWindow)) ||
			((DBScreen) && CheckWindow(DBWindow)))*BREAK));
}

void UpScreen(struct Screen *Screen) {
	ScreenToFront(Screen);
	if (!ASKED(OPT_NOACTIVATE)) ActivateWindow(Screen->FirstWindow);
}

void CondBlackUp(void) {
	if ((BlackScreen) && (!ASKED(OPT_DOUBLEBUFFERING))) UpScreen(BlackScreen);
}

void CondFreeScreen(struct Screen *Screen) {
	if (Screen) {
		ScreenToBack(Screen);
		if (Screen->FirstWindow) CloseWindow(Screen->FirstWindow);
		CloseScreen(Screen);
	}
}

char *AnchorWBArg(char *Anchor, int i) {
	if (BaseName(WBenchMsg->sm_ArgList[i].wa_Name) == WBenchMsg->sm_ArgList[i].wa_Name) {
		PathName(WBenchMsg->sm_ArgList[i].wa_Lock, Anchor, sizeof(struct UserAnchor)/DSIZE-1);
		TackOn(Anchor, WBenchMsg->sm_ArgList[i].wa_Name);
	}
	else strcpy(Anchor, WBenchMsg->sm_ArgList[i].wa_Name);
	return(Anchor);
}


char *JoinToolTypes(char *Anchor) {

	struct DiskObject *D;
	int i, l;
	char *Tools = NULL;

	if (D = GetDiskObject((char *)Anchor)) {
		if (D->do_ToolTypes) {
			i = l = 0;
			while(D->do_ToolTypes[i]) l += strlen(D->do_ToolTypes[i++])+1;
			Tools = ArpAlloc(l+1);
			i = 0;
			while(D->do_ToolTypes[i]) {
				strcat(Tools, D->do_ToolTypes[i++]);
				strcat(Tools, " ");
			}
		}
		FreeDiskObject(D);
		if ((Tools) && (*Tools)) return(Tools);
	}

	return(NULL);
}


void CheckVal(int OPT_N, int min, int max, char *Name) {

	long t;

	if (argv[OPT_N]) {
		t = Atol(argv[OPT_N]);
		if ((t > max) || (t < min) || (IoErr())) {
				Printf("%s must be a number between %ld and %ld\n", Name, min, max);
				argv[OPT_N] = NULL;
		}
		else argv[OPT_N] = (char *)(t+1);
	}
}



int __stdargs main(int argc, char **argvv) {

	long result, t, l;

	USHORT i, RC = OK;
	struct UserAnchor *Anchor;
	struct FileRequester *FileRequester = NULL;
	char *Sel, **ExtSel, **StartupArgs;

	if ((argc == 1) && (!ArpLock(StartupFiles[0], ACCESS_READ))) {
		Puts(CLI_Help);
		return(0);
	}

	argv = argvv;

	if (GfxBase->LibNode.lib_Version>=37) NewOS = TRUE;
	if (GfxBase->LibNode.lib_Version>=39) NewerOS = TRUE;

	if ((Anchor = ArpAlloc(sizeof(struct UserAnchor))) == NULL) return(30);
	if ((NewScreen = ArpAlloc(sizeof(struct ExtNewScreen))) == NULL) return(30);
	if ((NewWindow = ArpAlloc(sizeof(struct NewWindow))) == NULL) return(30);
	if ((SpriteData = ArpAllocMem(8, MEMF_CHIP | MEMF_CLEAR)) == NULL) return(30);
	if ((RangeReq = ArpAlloc(8*sizeof(struct timerequest))) == NULL) return(30);
	if ((timereq = ArpAlloc(sizeof(struct timerequest))) == NULL) return(30);

	if (argc == 0) {
		if ((argv = ArpAlloc(OPT_DUMMYCOUNT*4)) == NULL) return(30);
		if ((IconBase = ArpOpenLibrary("icon.library",0)) == NULL) return(20);
		Sel = NULL;
		if (WBenchMsg->sm_NumArgs > 1)
			if (Sel = JoinToolTypes(AnchorWBArg((char *)Anchor,1)))
				if (!(t=Strncmp(Sel,"STARTUP",7)))
					if (CheatGo(Sel+7, strlen(Sel+7), argv+1)) return(20);

		if ((Sel == NULL) || (t))
			if (Sel = JoinToolTypes(AnchorWBArg((char *)Anchor,0)))
				if (CheatGo(Sel, strlen(Sel), argv+1)) return(20);

		if (WBenchMsg->sm_NumArgs > 1) {
			if ((ExtSel = ArpAlloc(WBenchMsg->sm_NumArgs*4)) == NULL) return(30);
			for(i=1, l=0; i<WBenchMsg->sm_NumArgs; i++)
				if (t = Lock(AnchorWBArg((char *)Anchor, i), ACCESS_READ)) {
					UnLock(t);
					if ((ExtSel[l] = ArpAlloc(strlen((char *)Anchor)+1)) == NULL) return(30);
					strcpy(ExtSel[l++], (char *)Anchor);
				}
			if (ExtSel[0]) argv[OPT_NAMES] = (char *)ExtSel;
		}
	}

	if ((argv[OPT_NAMES]) && (!((char **)argv[OPT_NAMES])[0])) argv[OPT_NAMES] = NULL;

	if (!ASKED(OPT_NOSTARTUP)) {
		if ASKED(OPT_BATCH) StartupFiles[(argc == 0)] = argv[OPT_BATCH];
		if (t = ArpOpen(StartupFiles[(argc == 0)], MODE_OLDFILE)) {
	      Seek(t, 0, OFFSET_END);
			l = Seek(t, 0, OFFSET_BEGINNING);
			if ((Sel = ArpAlloc(l+1)) == NULL) return(30);
			if ((StartupArgs = ArpAlloc(OPT_DUMMYCOUNT*4)) == NULL) return(30);
			Read(t, Sel, l);
			Sel[l] = 0;
			if (CheatGo(Sel, l, StartupArgs)) {
				Puts("Error in startup file");
				return(20);
			}
			else
				for(l=1; l<OPT_DUMMYCOUNT; l++)
					if (StartupArgs[l-1])
						switch(l) {

							case OPT_NAMES:
								if ((((char **)StartupArgs[OPT_NAMES-1])[0]) && (argv[OPT_NAMES] == NULL))
										argv[OPT_NAMES] = StartupArgs[OPT_NAMES-1];
								break;
							case OPT_WIDTH:
							case OPT_HEIGHT:
							case OPT_FADE:
							case OPT_SECS:
								if (!ASKED(l)) argv[l] = StartupArgs[l-1];
								break;

							case OPT_BATCH:
								break;

							default:
								if ASKED(l) argv[l] = NULL;
								else argv[l] = (char *)1;
								break;
						}
		}
		else if (!ASKED(OPT_QUIET)) Puts("Startup file not found, using built-in defaults");
	}


	NewWindow->Type = CUSTOMSCREEN;

	if ((argv[OPT_NAMES] == NULL) || (*(*((char **)argv[OPT_NAMES]))=='!')) {
		if ((FileRequester = ArpAllocFreq()) == NULL) return(30);
		FileRequester->fr_Hail = "Select a file to show";
		FileRequester->fr_Flags2 |= FR2F_LongPath;
		if (argc == 0) argv[OPT_REPEAT] = (void *)1;
		argv[OPT_DOUBLEBUFFERING] = NULL;
	}

	if ASKED(OPT_BLACKBACKG) {
		NewScreen->Type = CUSTOMSCREEN | SCREENQUIET | SCREENBEHIND;
		NewWindow->Width = NewScreen->Width = GfxBase->NormalDisplayColumns/2;
		NewWindow->Height = NewScreen->Height = GfxBase->NormalDisplayRows;
		BlackScreen = OpenScreen(NewScreen);
		if (NewWindow->Screen = BlackScreen) {
			SetRGB4(&(BlackScreen->ViewPort),0,0,0,0);
			NewWindow->Flags = SIMPLE_REFRESH | BACKDROP | BORDERLESS | NOCAREREFRESH | ACTIVATE*(!ASKED(OPT_NOACTIVATE));
			NewWindow->IDCMPFlags = RAWKEY;
			if ((BlackWindow = OpenWindow(NewWindow)) == NULL) {
				CloseScreen(BlackScreen);
				return(30);
			}
			CondKillMouse(BlackWindow);
		}
		else return(30);
		if (FileRequester == NULL) UpScreen(BlackScreen);
	}
	else NewScreen->Type = CUSTOMSCREEN | SCREENQUIET | SCREENBEHIND*ASKED(OPT_DOUBLEBUFFERING);

	NewWindow->IDCMPFlags = MOUSEBUTTONS | RAWKEY;
	NewWindow->Flags = SMART_REFRESH | BACKDROP | BORDERLESS | RMBTRAP | ACTIVATE*(!ASKED(OPT_BLACKBACKG))*(!ASKED(OPT_NOACTIVATE))*(!ASKED(OPT_DOUBLEBUFFERING));

	CheckVal(OPT_FADE, 1, 4, "Fade speed");
	CheckVal(OPT_SECS, 0, 1000, "Seconds");
	CheckVal(OPT_WIDTH, 128, 1024, "Screen width");
	CheckVal(OPT_HEIGHT, 128, 1024, "Screen height");

	memset(Anchor, 0, sizeof(struct UserAnchor));
	Anchor->ua_AP.ap_StrLen = 512;
	Anchor->ua_AP.ap_BreakBits = SIGBREAKF_CTRL_C;
	if ASKED(OPT_ALL) Anchor->ua_AP.ap_Flags = APF_DoWild;

	if ((Port = CreatePort(NULL, 0)) == NULL) goto ExitClosingScreens;

	if (OpenDevice(TIMERNAME, UNIT_VBLANK, (struct IORequest *)timereq, 0)) {
		RC = MEMORY;
		goto ExitClosingScreens;
	}

	timereq->tr_node.io_Message.mn_ReplyPort = Port;
	timereq->tr_node.io_Message.mn_Length = sizeof(struct timerequest) - sizeof(struct Message);
	timereq->tr_node.io_Command = TR_ADDREQUEST;

	for(i=0; i<8; i++) RangeReq[i] = *timereq;

	do {
		if (FileRequester) {
			if (BlackScreen) ScreenToBack(BlackScreen);
			if ((Sel = FileRequest(FileRequester)) && (*Sel)) {
				TackOn(FileRequester->fr_Dir, FileRequester->fr_File);
				CondBlackUp();
				RC = ReadIFFFile(FileRequester->fr_Dir);

				if ( ((Sel = BaseName(FileRequester->fr_Dir)) != FileRequester->fr_Dir) && (*(Sel-1) != ':') ) *(Sel-1) = 0;
				else *Sel = 0;
			}
			else break;
		}
		else {
			i = 0;
			while((!RC) && (((char **)argv[OPT_NAMES])[i])) {

				result = FindFirst(((char **)argv[OPT_NAMES])[i++], (struct AnchorPath *)Anchor);
				t = 0;

				if (result == ERROR_OBJECT_NOT_FOUND) Printf("No match for %s\n", ((char **)argv[OPT_NAMES])[i-1]);

				while(!((result) || (RC))) {
					if (CheckAll()) {
						RC = BREAK;
						break;
					}
					if (Anchor->ua_AP.ap_Info.fib_DirEntryType < 0) {
							RC = ReadIFFFile(Anchor->ua_AP.ap_Buf);
							t = 1;
					}
					else if ASKED(OPT_ALL)
						if (!(Anchor->ua_AP.ap_Flags & APF_DidDir))
							Anchor->ua_AP.ap_Flags |= APF_DoDir;
						else Anchor->ua_AP.ap_Flags &= ~APF_DidDir;
					result = FindNext((struct AnchorPath *)Anchor);
				}

				FreeAnchorChain((struct AnchorPath *)Anchor);

				if (RC == BREAK) break;

				switch (result) {
					case ERROR_BREAK:
						RC = BREAK;
						break;
					case ERROR_NO_MORE_ENTRIES:
						if (t) result = 0;
						break;
					case ERROR_OBJECT_NOT_FOUND:
						break;
					default:
						RC = ERROR;
						break;
				}
			}
		}

		if (RC == MEMORY) {
			Puts("Not enough memory");
			break;
		}
		else if (RC == BREAK) {
			Puts("***Break");
			break;
		}
		else if (RC == ERROR) {
			Puts("I/O error");
			break;
		}
		else if (result) break;
	} while(ASKED(OPT_REPEAT));


	CloseDevice((struct IORequest *)timereq);

ExitClosingScreens:

	CondFreeScreen(DBScreen);
	CondFreeScreen(BlackScreen);

	if (Port) DeletePort(Port);

	return(20*( (RC == ERROR)||(RC == MEMORY) ));
}
