#include "M.h"
#include <iff/pchg.h>

#define MakeID(a,b,c,d)  ( (ULONG)(a)<<24L | (ULONG)(b)<<16L | (c)<<8 | (d) )
#define FORM    MakeID('F','O','R','M')
#define LIST    MakeID('L','I','S','T')
#define PROP    MakeID('P','R','O','P')
#define CAT     MakeID('C','A','T',' ')
#define ID_ILBM MakeID('I','L','B','M')
#define ID_BMHD MakeID('B','M','H','D')
#define ID_CMAP MakeID('C','M','A','P')
#define ID_CAMG MakeID('C','A','M','G')
#define ID_SHAM MakeID('S','H','A','M')
#define ID_CTBL MakeID('C','T','B','L')
#define ID_CRNG MakeID('C','R','N','G')
#define ID_CCRT MakeID('C','C','R','T')
#define ID_BODY MakeID('B','O','D','Y')

extern struct Screen *DBScreen;
extern struct Window *DBWindow;
extern char **argv;

BOOL Display(GroupData *GroupData, int File, int ChunkLen);
BOOL CheckAll(void);

char There_Is_BODY;
struct CycleInfo TCI;


unsigned long int NextChunk(int File, long *ChunkLen) {

	unsigned long ID;

	Read(File, (void *)&ID, 4);
	Read(File, (void *)ChunkLen, 4);
	return(ID);
}


BOOL ReadGroup(unsigned int Type, int Length, GroupData *PrevGData, int File,
					struct DefaultTracker **PrevTracker, struct DefaultTracker **PCHGPrevTracker) {

	GroupData *GData;
	unsigned int Group_ID, Next;
	long ChunkLen;
	struct DefaultTracker *Tracker = (void *)(-1), *PCHGTracker = (void *)(-1);
	BOOL RC;
	short int RangeCount = 0;

	Length -= 4;
	Read(File, (void *)&Group_ID, 4);

	if ((*PrevTracker = (void *)(GData = ArpAlloc(sizeof(GroupData)))) == NULL) return(MEMORY);

	if ( (PrevGData) && (PrevGData->Group_Type == LIST) && (!(Type == PROP)) ) *GData = *PrevGData;

	GData->Group_Type = Type;

	while (Length>0) {

		switch (Next = NextChunk(File, &ChunkLen)) {
			case CAT:
			case LIST:
			case PROP:
			case FORM:
				RC = ReadGroup(Next, ChunkLen, GData, File, &Tracker, &PCHGTracker);
				if ((int)Tracker != -1) FreeTrackedItem(Tracker);
				if ((int)PCHGTracker != -1) FreeTrackedItem(PCHGTracker);
				if (RC) return(RC);
				break;

			case ID_BMHD:
				GData->FilledField[0] = 1;
				if (ChunkLen != sizeof(BitMapHeader)) return(ERROR);
				if (Read(File, (void *)&GData->BitMapHeader, sizeof(BitMapHeader)) < sizeof(BitMapHeader)) return(ERROR);
				break;

			case ID_CMAP:
				GData->FilledField[1] = 1;
				if ((ULONG)(GData->CMAP_Len = ChunkLen) > 768) return (ERROR);
				if (Read(File, (void *)GData->CMAP, EvenUp(ChunkLen)) < EvenUp(ChunkLen)) return(ERROR);
				break;

			case ID_CAMG:
				GData->FilledField[2] = 1;
				if (ChunkLen != 4) return(ERROR);
				if (Read(File, (void *)&GData->CAMG, 4) < 4) return(ERROR);
				break;

			case ID_PCHG:
			case ID_SHAM:
				if (Next == ID_PCHG) {
					if (GData->FilledField[3]) return(ERROR);
					GData->FilledField[3] = 1;
					if (GData->SHAMSize) {
						FreeTrackedItem(GData->PCHG);
						GData->SHAMSize = 0;
					}
				}
				else if (GData->FilledField[3]) {
					if (Seek(File, EvenUp(ChunkLen), OFFSET_CURRENT) == -1) return(ERROR);
					break;
				}
				else GData->SHAMSize = ChunkLen;
				if ((*PCHGPrevTracker = (void *)(GData->PCHG = ArpAlloc(ChunkLen))) == NULL) return(MEMORY);
				if (Read(File, (void *)GData->PCHG, ChunkLen) < ChunkLen) return(ERROR);
				break;

			case ID_CRNG:
				if (RangeCount < 8) {
					if (ChunkLen != sizeof(struct ColorRange)) return(ERROR);
					if (Read(File, (void *)&GData->Range[RangeCount++], sizeof(struct ColorRange)) < sizeof(struct ColorRange)) return(ERROR);
				}
				break;

			case ID_CCRT:
				if (RangeCount < 8) {
					if (ChunkLen != sizeof(struct CycleInfo)) return(ERROR);
					if (Read(File, (void *)&TCI, sizeof(struct CycleInfo)) < sizeof(struct CycleInfo)) return(ERROR);
					if (TCI.direction) GData->Range[RangeCount].flags = 1 | (TCI.direction+1);
					GData->Range[RangeCount].low = TCI.start;
					GData->Range[RangeCount].high = TCI.end;
					GData->Range[RangeCount].rate = (16667*16384)/(TCI.seconds*1000000+TCI.microseconds);
					RangeCount++;
				}
				break;

			case ID_BODY:
				if ( (Group_ID == ID_ILBM) && (Type == FORM) ) {
               There_Is_BODY = 1;
					if (RC = Display(GData, File, ChunkLen)) return(RC);
					break;
				}

			default:
				if (Seek(File, EvenUp(ChunkLen), OFFSET_CURRENT) == -1) return(ERROR);
		}

		if (CheckAll()) return(BREAK);
		Length -= EvenUp(ChunkLen) + 8;
	}

	if (Length != 0) return(ERROR);

	if (Type == PROP) {
		Next = PrevGData->Group_Type;
		*PrevGData = *GData;
		PrevGData->Group_Type = Next;
	}
	return(OK);
}


BOOL ReadIFFFile(char *FileName) {

	long int Len, File;
	unsigned long int Type;
	struct DefaultTracker *Tracker = (void *)(-1), *PCHGTracker = (void *)(-1);

	BOOL RC = OK;

	if ((File = Open(FileName, MODE_OLDFILE)) == NULL) {
		Printf("Can't open %s\n", FileName);
		return(OK);
	}

	if (!ASKED(OPT_QUIET)) Printf("Showing %s...\t", FileName);
	Read(File, (void *)&Type, 4);
	Read(File, (void *)&Len, 4);
	if (	(Type == FORM)	||
			(Type == CAT )	||
			(Type == PROP)	||
			(Type == LIST) ) {
		There_Is_BODY = 0;

		RC = ReadGroup(Type, Len, NULL, File, &Tracker, &PCHGTracker);

		if (RC == ERROR) {
			Puts("Bad IFF File");
			RC = OK;
		}
		else if ((There_Is_BODY) || (RC)) {
			if (!ASKED(OPT_QUIET)) Puts("");
		}
		else if (!ASKED(OPT_QUIET)) Puts("No pictures here");

		if ((int)Tracker != -1) FreeTrackedItem(Tracker);
		if ((int)PCHGTracker != -1) FreeTrackedItem(PCHGTracker);
	}
	else if (!ASKED(OPT_QUIET)) Puts("Not an IFF File");

	Close(File);
	return(RC);
}
