#include "SD.h"
#include <libraries/asl.h>
#include <proto/asl.h>

/* This file is for accessing the ASL file requester if available. */

static struct FileRequester *FileRequester;

static struct TagItem Tags[]={	{ ASL_Hail, (ULONG)&DefaultTitle },
											{ ASL_Dir, (ULONG)&DefaultDir },
											{ ASL_Pattern, (ULONG)&DefaultPattern },
											{ ASL_Window, NULL },
											{ ASLFR_SleepWindow, TRUE },
											{ ASL_FuncFlags, FILF_PATGAD | FILF_NEWIDCMP },
											{ TAG_DONE, NULL }	};

unsigned char *GetFile(void) {

	unsigned char *AS = NULL;
	unsigned int n;
	struct TagItem *t = &Tags[3];

	Tags[3].ti_Data = (ULONG)WindowPointer(WIN_MAIN);

	if (AslBase || (AslBase = (void *)OpenLibrary("asl.library", 37))) {
		if (!FileRequester) {
			if (!(FileRequester = AllocFileRequest())) return(NULL);
			t = Tags;
		}
		if (AslRequest(FileRequester, t) &&
			(n = strlen(FileRequester->rf_Dir)+strlen(FileRequester->rf_File)) &&
			(AS = CreateArgstring(FileRequester->rf_Dir, n+4)))
			AddPart(AS, FileRequester->rf_File, n+4);
		return(AS);
	}
	else return(NULL);
}

void ASLFreeFileReq(void) {
	CloseLibrary(AslBase);
	if (FileRequester) FreeFileRequest(FileRequester);
}
