#include "SDInc.h"

extern void kprintf(char *,... );

#ifdef DEBUG
#define D(x) k##x
#else
#define D(x)
#endif

#ifdef DEBUG
#define ASSERT(x) {if (!(x)) kprintf("%s is false at line %ld of %s\n", #x, (ULONG)__LINE__, __FILE__);}
#else
#define ASSERT(x)
#endif

#define BLOCKSIZE	1088

/*
 * This structure, directly derived from Dirk's code, allows for easy
 * parameter passing of the blitter operations.
 */

struct ExtendedBlitNode	{
	struct bltnode	EBN_bltnode;
	UWORD				EBN_Pad;
	APTR				EBN_P0;
	APTR				EBN_P1;
	APTR				EBN_P2;
	APTR				EBN_P3;
	ULONG				EBN_Mask;
	struct Task		*EBN_Task;
};

struct InterruptServerData {
	ULONG				ISD_Mask;
	struct Task		*ISD_Task;
};

struct DiskBlockServerData {
	struct InterruptServerData DBSD_ISD;
	struct Interrupt *DBSD_SoftInt;
};

struct SyncIntData {
	UBYTE SD_EnableSecCounter;
	UBYTE SD_GetSync;
	WORD	SD_SecCounter;
	struct MsgPort *SD_SyncIntPort;
	struct timerequest *SD_SyncInt_tr;
	struct Interrupt *SD_SyncInt;
};

struct SoftIntData {
	struct InterruptServerData SID_ISD;
	struct MsgPort *SID_SoftIntPort;
	struct timerequest *SID_SoftInt_tr;
	unsigned char	*SID_VerifyBuffer;
	USHORT	SID_VerifyLength;
	USHORT	SID_CIABPRB;
	ULONG		SID_ADKCON;
	struct DiskBlockServerData *SID_DiskBlockServerData;
};


#define	SE_Sync		(4)
#define	SE_Header	(SE_Sync+4)
#define	SE_Label		(SE_Header+8)
#define	SE_SumL		(SE_Label+TD_LABELSIZE*2)
#define	SE_SumD		(SE_SumL+8)
#define	SE_Data		(SE_SumD+8)

/*
* This macros read & write the bit masks such as ActualDest
*/

#define MASK(x) (1UL<<(x))
#define INDEST(x) ((MASK(x)) & Dest)
#define INACTUALDEST(x) ((MASK(x)) & ActualDest)
#define INMASK(x,y) (MASK(x) & (y))

/* Assumptions on the following enum:
   - All gadgets between DF0S and ECYL will understand GA_Disabled;
*/

enum Gadgets { DF0S, DF1S, DF2S, DF3S, DF0D, DF1D, DF2D, DF3D,
					STOP, COPY, READ, WRITE,
					CHECK, FORMAT, OPTIONS, INFO,
					AREXX, NOWB, SAVECONF, ICONIFY,
					VERIFY, DATE, COMPRESSION, PRINTERRORS,
					INCNAME, FFS, INTL, DIRCACHE, TALK, AUTO,
					LABEL, FILENAME, XPKLIB, VDNAME, VDNUMBER, RETRY, SCYL, ECYL,
					ELAPSED, COPYNUMBER, STATUS,
					COPYMODE,
					DISKLIST,
					GADGET_COUNT
				   };

enum RexxOnly { QUIT = GADGET_COUNT, REQUESTERS, RECALIBRATECHECK, SMARTREFRESH,
					SOURCE, DESTINATION,
					NOP, HELP, WINDOW, AREXX_COUNT };

enum Buffers { NO_BUFFER, RAM_BUFFER, HD_BUFFER, VDISK_BUFFER, BUFFER_COUNT };

enum ErrorCodes { ERR_CHECKSUM = 1, ERR_NOCOMP, ERR_IO, ERR_CANTOPENVDISK,
						ERR_IFF, ERR_CANTOPENFILE, ERR_WRONGTYPE, ERR_COMP };

#define TEMPLATE			"PubScreen/K,NoGUI/S,NoARexx/S,NoStartup/S"

enum opts_enum { OPT_PUBSCREEN, OPT_NOGUI, OPT_NOAREXX, OPT_NOSTARTUP, OPT_DUMMYCOUNT };

#define NO_COMMAND		NULL
#define STOP_COMMAND		"Stop"
#define COPY_COMMAND		"Copy"
#define READ_COMMAND		"Read"
#define WRITE_COMMAND	"Write"
#define OPTIONS_COMMAND	"Options"
#define CHECK_COMMAND	"Check"
#define FORMAT_COMMAND	"Format"
#define AREXX_COMMAND	"ARexx"
#define NOWB_COMMAND		"NoWB"
#define INFO_COMMAND		"Info"
#define ICONIFY_COMMAND		"Iconify"
#define SAVECONF_COMMAND	"SaveConf"
#define VERIFY_COMMAND		"Verify"
#define DATE_COMMAND			"Date"
#define COMP_COMMAND			"Comp"
#define INCNAME_COMMAND		"Incname"
#define FFS_COMMAND			"FFS"
#define INTL_COMMAND			"Intl"
#define DIRCACHE_COMMAND	"DirCache"
#define TALK_COMMAND			"Talk"
#define AUTO_COMMAND			"Auto"
#define LABEL_COMMAND		"Label"
#define FILENAME_COMMAND	"Filename"
#define XPKLIB_COMMAND		"XpkLib"
#define VDNAME_COMMAND		"VDName"
#define VDNUMBER_COMMAND	"VDUnit"
#define RETRY_COMMAND		"Retry"
#define SCYL_COMMAND			"SCyl"
#define ECYL_COMMAND			"ECyl"
#define COPYMODE_COMMAND	"Mode"
#define HELP_COMMAND			"Help"
#define RX_COMMAND			"RX"
#define NOP_COMMAND					"NOP"
#define QUIT_COMMAND				"Quit"
#define REQUESTERS_COMMAND		"Requesters"
#define RECALIBRATECHECK_COMMAND	"RecalibrateCheck"
#define SMARTREFRESH_COMMAND		"SmartRefresh"
#define PRINTERRORS_COMMAND		"PrintErrors"
#define SOURCE_COMMAND				"Source"
#define DESTINATION_COMMAND		"Dest"
#define WINDOW_COMMAND				"Window"

#define NO_TEMPLATE				","
#define ONOFF_TEMPLATE			"On/S,Off/S"
#define STRING_TEMPLATE			"/A"
#define NUMBER_TEMPLATE			"/N/A"
#define COPYMODE_TEMPLATE		"Disk2Disk/S,Buffer/S,HDBuffer/S,VDBuffer/S"
#define DESTINATION_TEMPLATE	"/M/N," ONOFF_TEMPLATE
#define SOURCE_TEMPLATE 		"/N,Off/S"
#define HELP_TEMPLATE			"Command"
#define RX_TEMPLATE				"Command/F"
#define WINDOW_TEMPLATE			"Names/M/A,Open/S,Close/S,Activate/S,Min/S,Max/S,Front/S,Back/S,LeftEdge/K/N,TopEdge/K/N"

enum OnOffOptions		{ ON, OFF };
enum WindowOptions	{ NAMES, OPENIT, CLOSEIT, ACTIVATEIT, MINIT, MAXIT, FRONT, BACK, LEFTEDGE, TOPEDGE };
enum SourceOptions	{ DRIVE, SOURCEOFF };
enum DestOptions		{ DRIVES, DESTON, DESTOFF };
enum Windows			{ WIN_MAIN, WIN_OPTIONS, WIN_INFO, WIN_COUNT };

extern unsigned char *WindowName[WIN_COUNT];

#define WINDOW_NUMBER(x)  ((int)((x)->UserData))

#define COMMF_NOARGS (1<<0)

typedef struct {
	char *Name;
	char *Template;
	UBYTE NameLen;
	UBYTE Action;
	UBYTE Flags;
} CommandData;


#include "AsmProtos.h"
#include "Protos.h"
