#include "SD.h"
#include <proto/keymap.h>

/* NOTE: apart from the CopyTask*() functions, all this module has to be used
	only from the main task. */

char df[4][5] = { "df0:", "df1:", "df2:", "df3:" }; /* These ones are useful with Inhibit() */

ULONG StepDelay;
ULONG SettleDelay;
ULONG CalibrateDelay;
ULONG CurrentType = DRT_AMIGA;	/* The type currently in use; DRT_AMIGA or DRT_150RPM */

struct IntuitionBase *IntuitionBase;
struct GfxBase *GfxBase;
struct DosLibrary *DOSBase;
struct Library *AslBase;
struct Library *GadToolsBase;
struct Library *KeymapBase;
struct Library *TimerBase;
struct Library *UtilityBase;
struct Library *WorkbenchBase;
struct Library *IconBase;
struct Library *XpkBase;
struct Library *XpkComp;

unsigned short int GapSize;
unsigned short int SPT;
unsigned short int TrackSize;
unsigned short int RAMBufferBlock;
unsigned short int ReadBufferSize;
unsigned short int VerifyBufferSize;
unsigned short int WriteLength;
unsigned short int ReadLength;
unsigned short int VerifyLength;
unsigned short int GapAdd;
unsigned short int MinGap;
unsigned short int RootBlock;

unsigned char	DefaultDir[] = "REXX:",
					DefaultPattern[] = "#?.supdup",
					DefaultTitle[] = "Select an ARexx program",
					ARexxPortName[] = "SUPERDUPER";

struct MsgPort *TPort,			/* For all temporary (sync) IOs */
					*ARexxPort, 	/* For ARexx */
					*ClickPort, 	/* For the click timings */
					*ResPort,		/* For the resource messages */
					*AppPort;		/* For the AppIcon stuff */

struct Task *Me, *Copier;

static unsigned char	NoDiskResourceMsg[] = "Can't get disk.resource.";
static unsigned char	FreeDiskResMsg[] = "Please free disk.resource.";

/* This are all signals of the copy task */

static signed char	StoreSignal = -1,		/* Store is over signal */
							EBNSignal = -1,		/* Blitter finished signal */
							ISDSignal = -1,		/* Disk read/write finished signal */
							StartSignal = -1,		/* "Start the copy" signal */
							StopSignal = -1;		/* "Stop the copy" signal */

/* This are all signals of the main task */

static signed char	CopierSignal = -1;		/* When the copy task has something to say */

static unsigned char GotUnit,			/* I *have* the disk.resource */
							InhibitMask,	/* What drives did I inhibit? */
							DRUPosted;		/* There's a DRU posted with no reply still hanging */



void FlushMem(void) {

	void *p;
	if (p = AllocMem(0x80000000UL, MEMF_PUBLIC)) FreeMem(p, 0x80000000UL);
	if (p = AllocMem(0x80000000UL, MEMF_PUBLIC)) FreeMem(p, 0x80000000UL);
}

/* We	discover what '0', '1', etc. and SHIFT-'0', SHIFT-'1' etc. is.
	We put the result in GadgetKey[]. We use TPort. */

static void CalcShiftedKeyCodes(void) {

	struct InputEvent ievent = { NULL, IECLASS_RAWKEY };
	unsigned char c,i;

	for(i=0; i<4; i++) {
		ievent.ie_Code = (i ? i : 10);
		ievent.ie_position.ie_addr = NULL;
		ievent.ie_Qualifier = 0;
		if (MapRawKey(&ievent, &c, 1, NULL)>0) GadgetKey[i] = c;
		ievent.ie_Qualifier = (IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT);
		if (MapRawKey(&ievent, &c, 1, NULL)>0) GadgetKey[i+DF0D] = c;
	}
}

unsigned char DeadKeyConvert(struct IntuiMessage *msg) {

	unsigned char c;
	static struct InputEvent ievent = { NULL, IECLASS_RAWKEY };

	ievent.ie_Code = msg->Code;
	ievent.ie_Qualifier = msg->Qualifier;
	ievent.ie_position.ie_addr = *((APTR *)msg->IAddress);
	if (MapRawKey(&ievent, &c, 1, NULL)>0) return(c);
	else return(0);
}

static void FreeTDBuffers(void) {
	int i;

	for(i=0; i<3; i++) {
		FreeVec(ReadBuffer[i]);
		ReadBuffer[i] = NULL;
	}
	for(i=0; i<2; i++) {
		FreeVec(VerifyBuffer[i]);
		VerifyBuffer[i] = NULL;
	}
}


unsigned short ReAllocTDBuffers(void) {

	static ULONG CurrentBufferType = DRT_EMPTY;
	unsigned short i;

	if (CurrentBufferType == CurrentType) return(TRUE);

	ASSERT(CurrentType == DRT_AMIGA || CurrentType == DRT_150RPM)

	i = (CurrentType == DRT_AMIGA ? 1 : 2);

	FreeTDBuffers();

	GapSize = 1660*i;
	SPT = 11*i;
	TrackSize = SPT*512;
	RAMBufferBlock = TrackSize*2;
	ReadBufferSize = SPT*BLOCKSIZE+2*GapSize+2+8;
	VerifyBufferSize = SPT*BLOCKSIZE+GapSize+2+8;
	WriteLength = SPT*BLOCKSIZE+2;
	ReadLength = SPT*BLOCKSIZE+2;
	VerifyLength = SPT*BLOCKSIZE+2;
	GapAdd = 192*i;
	MinGap = 532*i;
	RootBlock = 880*i;

	D(printf("SPT: %ld   GapSize: %ld   RAMBufferBlock: %ld\n", (ULONG)SPT, (ULONG)GapSize, (ULONG)RAMBufferBlock);)

	for(i=0; i<3; i++)
		if (ReadBuffer[i] = AllocVec(ReadBufferSize, MEMF_CHIP))
			memset(ReadBuffer[i], 0xAA, GapSize+8);
	for(i=0; i<2; i++) VerifyBuffer[i] = AllocVec(VerifyBufferSize, MEMF_CHIP);

	ASSERT(VerifyBuffer[0] && VerifyBuffer[1] && ReadBuffer[0] && ReadBuffer[1] && ReadBuffer[2])

	if (i = (VerifyBuffer[0] && VerifyBuffer[1] && ReadBuffer[0] && ReadBuffer[1] && ReadBuffer[2]))
		CurrentBufferType = CurrentType;
	else {
		FreeTDBuffers();
		CurrentBufferType = DRT_EMPTY;
	}
	return(i);
}

void InitStuff(void) {

	stdin = Input();
	stdout = Output();

	InitSemaphore(&Semaphore[WIN_MAIN]);
	InitSemaphore(&Semaphore[WIN_OPTIONS]);
	InitSemaphore(&Semaphore[WIN_INFO]);
	InitSemaphore(&HyperSemaphore);
}

/* Main allocation function. It allocates everything. If ARexx is set to one, tries to
	open ARexx. If for any reason (no ARexx or no file requester) the gadget ARexx should
	be ghosted, it sets ARexx to 0. Check ARexxPort to see if you should use ARexx,
	the ARexx variable to see if you should activate the gadget (dirty and twisted, I agree).
	Moreover, the SignalSemaphore for sharing the video data is initialized. */

int AllocStuff(void) {

	InitSemaphore(&Semaphore[WIN_MAIN]);
	InitSemaphore(&Semaphore[WIN_OPTIONS]);
	InitSemaphore(&Semaphore[WIN_INFO]);
	InitSemaphore(&HyperSemaphore);

	if ((CopierSignal = AllocSignal(-1)) != -1) CopierMask = MASK(CopierSignal);

	TPort = CreateMsgPort();
	ResPort = CreateMsgPort();
	ClickPort = CreateMsgPort();
	AppPort = CreateMsgPort();

	if (ARexx && !InitARexx()) ARexx = 0;

	GadToolsBase = OpenLibrary("gadtools.library", 37);
	UtilityBase = OpenLibrary("utility.library", 37);
	WorkbenchBase = OpenLibrary("workbench.library", 37);
	IntuitionBase = (void *)OpenLibrary("intuition.library", 37);
	GfxBase = (void *)OpenLibrary("graphics.library", 37);

	if (KeymapBase = OpenLibrary("keymap.library", 37)) CalcShiftedKeyCodes();

	return(KeymapBase && GadToolsBase && UtilityBase && WorkbenchBase && IntuitionBase && GfxBase && CopierSignal != -1 && TPort && AppPort && ClickPort && ResPort && (!RexxSysBase || ARexxPort));
}

int CopyTaskAllocStuff(void) {

	if ((StopSignal = AllocSignal(-1)) != -1) StopMask = MASK(StopSignal);
	if ((StartSignal = AllocSignal(-1)) != -1) StartMask = MASK(StartSignal);
	if ((StoreSignal = AllocSignal(-1)) != -1) StoreMask = MASK(StoreSignal);
	if ((EBNSignal = AllocSignal(-1)) != -1) EBN.EBN_Mask = MASK(EBNSignal);
	if ((ISDSignal = AllocSignal(-1)) != -1) DiskBlockServerData.DBSD_ISD.ISD_Mask = SoftIntData.SID_ISD.ISD_Mask = MASK(ISDSignal);

	return(StartSignal != -1 && StopSignal != -1 && StoreSignal != -1 && EBNSignal != -1 && ISDSignal != -1);
}


/* No comment */

void FreeStuff(void) {

	FreeSignal(CopierSignal);
	FreeTDBuffers();
	CloseARexx();
	CloseLibrary(GadToolsBase);
	CloseLibrary(UtilityBase);
	CloseLibrary(WorkbenchBase);
	CloseLibrary(IntuitionBase);
	CloseLibrary(GfxBase);
	CloseLibrary(KeymapBase);
	CloseLibrary(XpkBase);
	CloseLibrary(XpkComp);
	DeleteMsgPort(TPort);
	DeleteMsgPort(ClickPort);
	DeleteMsgPort(ResPort);
	DeleteMsgPort(AppPort);
}

void CopyTaskFreeStuff(void) {

	FreeSignal(StartSignal);
	FreeSignal(StopSignal);
	FreeSignal(StoreSignal);
	FreeSignal(EBNSignal);
	FreeSignal(ISDSignal);
}


/*
 *	  Now we try to allocate a disk.	 First, we attempt to allocate an
 *	  I/O request, and then we actually open the device.	If either of
 *	  these fail, we return 0.	 This can occur if a drive is opened that
 *	  doesn't exist. The drive will get TPort as its I/O port.
 */
static struct IOStdReq *OpenDisk(unsigned char Unit) {

	register struct IOStdReq *IOStdReq;

	if ((IOStdReq = CreateIORequest(TPort, sizeof(struct IOStdReq))) && OpenDevice(TD_NAME, Unit, IOStdReq, 0) == 0) return(IOStdReq);
	DeleteIORequest(IOStdReq);
	return(NULL);
}

/*
 *	  Here we release a disk.	We close the device, kill the I/O request, and exit.
 */
static void CloseDisk(struct IOStdReq *IOStdReq) {
	CloseDevice(IOStdReq);
	DeleteIORequest(IOStdReq);
}

/*
 * We check which disks are present. We return an ULONG which we will OR
 * with the EnableGadgets standard mask. We use TPort. We return 0 if
 * the unit 0 can't be opened.
 */

unsigned char WhichDisks(void) {

	register unsigned char i, result = 0;
	register struct IOStdReq *IOStdReq;
	ULONG type;

	for(i=0; i<4; i++) {
		if ((type = GetUnitID(i)) == DRT_AMIGA || type == DRT_150RPM) {
			if (type == DRT_150RPM) CurrentType = DRT_150RPM;
			if (IOStdReq = OpenDisk(i)) {
				TDU_PublicUnit[i] = (struct TDU_PublicUnit *)IOStdReq->io_Unit;
				StepDelay = max(StepDelay, TDU_PublicUnit[i]->tdu_StepDelay);
				SettleDelay = max(SettleDelay, TDU_PublicUnit[i]->tdu_SettleDelay);
				CalibrateDelay = max(CalibrateDelay, TDU_PublicUnit[i]->tdu_CalibrateDelay);
				CloseDisk(IOStdReq);
			}
			result |= 0x11<<i;
		}
	}
	if (result & 1) return(result);
	else return(0);
}



/* Here we remove the posted DRU. Until it arrives, the program is
	forced to hang! */

void RemovePostedDRU(void) {
	if (DRUPosted) {
		while(!GetMsg(ResPort)) Acknowledge(FreeDiskResMsg);
		DRUPosted = 0;
	}
}

/* Here we grab the units, stealing them from the system. We recalibrate
	the heads and we store the original track, so we can get out of here
	under 1.3 without asking for ejection of all disks. */

unsigned char GrabUnits(unsigned char UnitMask) {

	unsigned char Unit;

	if (GotUnit) return(1);

	if (DRUPosted) {
		if (GetMsg(ResPort)) DRUPosted = 0;
		else {
			Acknowledge(NoDiskResourceMsg);
			return(0);
		}
	}

	UnitMask &= 0xF;

	for(Unit=0; Unit<4; Unit++)
		if (TDU_PublicUnit[Unit]) {
			Inhibit(df[Unit], DOSTRUE);
			InhibitMask |= MASK(Unit);
		}

	if (!GetUnit(&DRU)) {
		DropUnits();
		Acknowledge(NoDiskResourceMsg);
		DRUPosted = 1;
		return(0);
	}

	GotUnit = 1;
	for(Unit=0; Unit<4; Unit++) if (INMASK(Unit,UnitMask)) FindTrack(Unit);
	return(1);
}

/* We release the units to the system. First of all, we restore the heads to the
	original position. */

void DropUnits(void) {

	unsigned char Unit;

	if (GotUnit) {
		for(Unit=0; Unit<4; Unit++)
			if (TDU_PublicUnit[Unit]) SetPublicUnit(Unit);
		GiveUnit();
		GotUnit = 0;
	}
	if (InhibitMask) {
		for(Unit=0; Unit<4; Unit++) if (INMASK(Unit,InhibitMask)) Inhibit(df[Unit],FALSE);
		InhibitMask = 0;
	}
}
