#include "SD.h"
#include <proto/wb.h>
#include <graphics/clip.h>
#include <graphics/gfxmacros.h>
#include <libraries/amigaguide.h>
#include <clib/amigaguide_protos.h>
#include <pragmas/amigaguide_pragmas.h>
#include <graphics/videocontrol.h>

#define MAXLISTWIDTH 32

struct MsgPort *WindowPort;

unsigned char *WindowName[WIN_COUNT] = { "Main", "Options", "Info" };

static struct Library *AmigaGuideBase;
struct SignalSemaphore HyperSemaphore;

static struct Gadget *Gadget[GADGET_COUNT];
static struct Gadget *GList[WIN_COUNT];

static char *GadgetText[] = {
								"df_0:",
								"df_1:",
								"df_2:",
								"df_3:",
								"df_0:",
								"df_1:",
								"df_2:",
								"df_3:",
								"_Stop",
								"_Copy",
								"_Read",
								"_Write",
								"Chec_k",
								"_Format",
								"_Options",
								"_Info",
								"ARe_xx",
								"NoWB",
								"SaveCon",
								"Iconify",
								"_Verify",
								"_Date",
								"Com_p",
								"PrintErrors",
								"IncName",
								"FFS_.",
								"I_ntl",
								"DirCac_he",
								"_Talk",
								"_Auto",
								"_Label",
								"Filename",
								"Xpk Li_b",
								"Name",
								"_Unit",
								"Retr_y",
								"Start Cylinder",
								"End Cylinder",
								"Elapsed",
								"Copy #",
								"Status",
								"Disk2Disk",
								"Buffer",
								"HD Buffer",
								"VD Buffer",
								NULL
							};


char GadgetKey[] = { "0123!@#$SCRWKFOIX\0\0\0VDPE\0.NHTALEB\0UY\0\0\0\0\0M" };

static unsigned long EnableState = 0xFFFFFFFFUL;
static unsigned char GadgetState[LABEL] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0 };

#define LABEL_STR_LEN		31
#define FILENAME_STR_LEN	255
#define XPK_STR_LEN			8
#define VD_STR_LEN			255

static unsigned char LabelString[LABEL_STR_LEN+1] = "Empty";
static unsigned char FilenameString[FILENAME_STR_LEN+1] = "SD_Buffer";
static unsigned char XpkString[XPK_STR_LEN+1] = "BLZW";
static unsigned char VDString[VD_STR_LEN+1] = "ramdrive.device";

static unsigned char *GadgetString[VDNUMBER-LABEL] = { LabelString, FilenameString, XpkString, VDString };
static unsigned short GadgetNumber[ELAPSED-VDNUMBER] = { 0, 4, 0, 79 };
static struct EClockVal LastEClock;
static char ElapsedString[16];
static char StatusString[16] = "Idle";
static unsigned char CopyMode, SysKilled, Iconified;
static struct List DiskList = { (struct Node *)&DiskList.lh_Tail, NULL, (struct Node *)&DiskList.lh_Head };

unsigned char s[128];	/* Temp string */

static unsigned char ScreenTitle[] = "SuperDuper 3.13 Copyright  1991-1994 Sebastiano Vigna";
static unsigned char Title[] = "SuperDuper 3.13 by Sebastiano Vigna";
static unsigned char InfoTitle[] = "SuperDuper 3.13 Info Window";
static unsigned char OptTitle[] = "SuperDuper 3.13 Options Window";

static unsigned char NoCloseWB[] = "Can't close Workbench.";
static unsigned char NoOpenWB[] = "Can't open Workbench.";
static unsigned char CloseHyperSystem[] = "Please close the help system.";
static unsigned char HelpFileName[] = "SuperDuper.guide";
static unsigned char HelpTaskName[] = "SD_Help";


static APTR OldWindowPtr, CopyTaskOldWindowPtr;			/* Old WindowPtr in the Process structure */

struct SignalSemaphore Semaphore[WIN_COUNT];

/* This is for the Zoom gadget under 2.0 */

static WORD ZoomPos[WIN_COUNT][4];
static WORD Pos[WIN_COUNT][4] = {	{ 32, 32 }, { 300, 300 }, { 32, 300 }	};
static char Zoomed[WIN_COUNT], ZoomIsLarge[WIN_COUNT];
struct Window *Window[WIN_COUNT];			/* the windows */

char *PubScreen;

struct DiskObject *DiskObject;
struct AppIcon *AppIcon;

static struct TextAttr *TextAttr, Topaz8 = {(STRPTR)"topaz.font", TOPAZ_EIGHTY, 0, 0 };
static struct TextFont *Font;
static char TopBorder, LeftBorder;			/* Font adaptivity */
static struct Screen *Screen;
static unsigned short int XSize, YSize;
static struct VisualInfo *VisualInfo;
static unsigned short int ShinePen = 0, ShadowPen = 1, HighPen = 1, WidthFactor = 1;
static unsigned short Pattern[2] = { 0xAAAA, 0x5555 };

/* Very simple use of AmigaGuide. Could be done better, but it's not yet time. */

void __saveds HyperHelpTask(void) {

	struct NewAmigaGuide *NewAmigaGuide;
	AMIGAGUIDECONTEXT *h;
	BPTR CDLock;

	if (AttemptSemaphore(&HyperSemaphore)) {
		SetTaskPri(FindTask(NULL),0);
		if (AmigaGuideBase = OpenLibrary("amigaguide.library",0)) {
			if (NewAmigaGuide = AllocMem(sizeof(struct NewAmigaGuide), MEMF_PUBLIC | MEMF_CLEAR)) {
				NewAmigaGuide->nag_Lock = CDLock = DupLock(((struct Process *)Me)->pr_CurrentDir);
				NewAmigaGuide->nag_Name = HelpFileName;
				NewAmigaGuide->nag_BaseName = ARexxPortName;
				NewAmigaGuide->nag_Screen = Screen;
				if (h = OpenAmigaGuideA(NewAmigaGuide, NULL)) CloseAmigaGuide(h);
				FreeMem(NewAmigaGuide, sizeof(struct NewAmigaGuide));
				UnLock(CDLock);
			}
			CloseLibrary(AmigaGuideBase);
		}
		ReleaseSemaphore(&HyperSemaphore);
	}
}


void HyperHelp(void) {

	if (AttemptSemaphore(&HyperSemaphore)) {
		ReleaseSemaphore(&HyperSemaphore);
		CreateNewProcTags(NP_Entry, HyperHelpTask, NP_Name, HelpTaskName, NP_Priority, (ULONG)(Me->tc_Node.ln_Pri+1), TAG_DONE);
	}
}

void CloseHyperHelp(void) {

	while(!AttemptSemaphore(&HyperSemaphore)) Acknowledge(CloseHyperSystem);
	ReleaseSemaphore(&HyperSemaphore);
}


void Acknowledge(unsigned char *Message) {

	static struct EasyStruct es = {
												sizeof(es),
												0,
												"SuperDuper",
												NULL,
												"OK"
											};

	Say(Message);
	if (Requesters) {
		es.es_TextFormat = Message;
		EasyRequestArgs(Window[WIN_MAIN], &es, NULL, NULL);
	}
}

static void ObtainAllSemaphores(void) {
	ObtainSemaphore(&Semaphore[WIN_INFO]);
	ObtainSemaphore(&Semaphore[WIN_OPTIONS]);
	ObtainSemaphore(&Semaphore[WIN_MAIN]);
}

static void ReleaseAllSemaphores(void) {
	ReleaseSemaphore(&Semaphore[WIN_MAIN]);
	ReleaseSemaphore(&Semaphore[WIN_OPTIONS]);
	ReleaseSemaphore(&Semaphore[WIN_INFO]);
}

void ShutScreen(void) {
	if (SysKilled) {
		CloseScreen(Screen);
		Screen = NULL;
	}
}


struct Window *WindowPointer(int WindowNumber) {
	return(Window[WindowNumber]);
}

static struct Window *GadgetWindow(int n) {
	if (n <= ICONIFY || n == COPYMODE) return(Window[WIN_MAIN]);
	if (n <= ECYL) return(Window[WIN_OPTIONS]);
	if (n <= DISKLIST) return(Window[WIN_INFO]);
	return(NULL);
}



static void StripIntuiMessages(struct MsgPort *mp, struct Window *win) {
	struct IntuiMessage *msg;
	struct Node *succ;

	msg = (struct IntuiMessage *) mp->mp_MsgList.lh_Head;
	while( succ =  msg->ExecMessage.mn_Node.ln_Succ ) {
		if( msg->IDCMPWindow ==  win ) {
	   	Remove( msg );
		   ReplyMsg( msg );
		}
		msg = (struct IntuiMessage *) succ;
	}
}

static void CloseWindowSafely(struct Window *win) {
	Forbid();
	StripIntuiMessages( win->UserPort, win );
	win->UserPort = NULL;
	ModifyIDCMP( win, 0L );
	Permit();
	CloseWindow( win );
}


void CloseWin(int WindowNumber) {

/*	WindowNumber = WindowNumber & 0xFF;  Temporary; workaround for GO bug */

	if (Window[WindowNumber]) {
		Pos[WindowNumber][0] = Window[WindowNumber]->LeftEdge;
		Pos[WindowNumber][1] = Window[WindowNumber]->TopEdge;
		Zoomed[WindowNumber] = ((Window[WindowNumber]->Flags & WFLG_ZOOMED) != 0) != ZoomIsLarge[WindowNumber];

		ObtainSemaphore(&Semaphore[WindowNumber]);

		if (WindowNumber == WIN_MAIN) CloseWindow(Window[WindowNumber]);
		else CloseWindowSafely(Window[WindowNumber]);

		FreeGadgets(GList[WindowNumber]);
		GList[WindowNumber] = NULL;
		Window[WindowNumber] = NULL;
		ReleaseSemaphore(&Semaphore[WindowNumber]);
	}
}


/* Close the window and restore WindowPtr */

void CloseAllWindows(void) {

	if (Window[WIN_MAIN]) {
		WindowPort = NULL;

		CloseWin(WIN_OPTIONS);
		CloseWin(WIN_INFO);
		CloseWin(WIN_MAIN);

		((struct Process *)Me)->pr_WindowPtr = OldWindowPtr;
		((struct Process *)Copier)->pr_WindowPtr = CopyTaskOldWindowPtr;

		FreeVisualInfo(VisualInfo);
		VisualInfo = NULL;

		CloseFont(Font);
		Font = NULL;
	}
}

/* This function can kill or restore the system (it's a toggle). It can be
	called only from the main task. */

unsigned short KillSys(short i) {

	static struct TagItem VCTags[] = { { VTAG_BORDERBLANK_SET, TRUE }, { TAG_DONE } };
	unsigned char	WBClosed = 1, ActiveWindows;

	if (Iconified) return(0);

	ActiveWindows = (Window[WIN_MAIN] != NULL) | (Window[WIN_INFO] != NULL)<<1 | (Window[WIN_OPTIONS] != NULL)<<2;

	CloseIcon();

	ObtainAllSemaphores();

	if (i != 0 && !SysKilled) {

		ULONG DisplayID = HIRES;

		if (Window[WIN_MAIN]) DisplayID = GetVPModeID(&Window[WIN_MAIN]->WScreen->ViewPort);
		else {
			struct Screen *S;

			if (S = LockPubScreen(NULL)) {
				DisplayID = GetVPModeID(&S->ViewPort);
				UnlockPubScreen(NULL, S);
			}
		}

		if (!(Screen = OpenScreenTags(NULL,
				SA_Width, max(640,LeftBorder*2+(ULONG)max(73*XSize, 24*XSize+25*YSize*WidthFactor)),
				SA_Height, max(200, TopBorder+(ULONG)(YSize*23)),
				SA_DisplayID, DisplayID,
				SA_SysFont, 1L,
				SA_Title, ScreenTitle,
				TAG_DONE))) return(0);
		else {
			VideoControl(Screen->ViewPort.ColorMap, VCTags);
			MakeScreen(Screen);
			RethinkDisplay();
			CloseAllWindows();
			WBClosed = CloseWorkBench();
			FlushMem();
			SysKilled = TRUE;
		}
	}
	else if (i<=0 && SysKilled) {

		if (!OpenWorkBench()) {
			ReleaseAllSemaphores();
			Acknowledge(NoOpenWB);
			return(0);
		}
		WBenchToFront();
		CloseAllWindows();
		ShutScreen();
		SysKilled = FALSE;
	}
	else {
		ReleaseAllSemaphores();
		return(0);
	}

	if ((ActiveWindows & 1) && !SetUpWindow()) {
		ReleaseAllSemaphores();
		ShutScreen();
		Signal(Copier, StopMask);
		Alert(AG_NoMemory);
		return(1);
	}

	if (ActiveWindows & 1<<1) SetUpInfoWindow();
	if (ActiveWindows & 1<<2) SetUpOptWindow();
	if (!WBClosed) Acknowledge(NoCloseWB);
	ReleaseAllSemaphores();
	return(0);
}



void CloseIcon(void) {
	if (Iconified) {
		RemoveAppIcon(AppIcon);
		AppIcon = NULL;
		FreeDiskObject(DiskObject);
		DiskObject = NULL;
		Iconified = FALSE;
	}
}


int Iconify(int bool) {

	static unsigned char ActiveWindows;

	if (bool && !Iconified) {
		if (DiskObject = GetDiskObjectNew("PROGDIR:SD")) {
			if (AppIcon = AddAppIconA(0, 0, "SuperDuper", AppPort, NULL, DiskObject, NULL)) {
				ActiveWindows = (Window[WIN_MAIN] != NULL) | (Window[WIN_INFO] != NULL)<<1 | (Window[WIN_OPTIONS] != NULL)<<2;
				CloseAllWindows();
				KillSys(FALSE);
				Iconified = TRUE;
				return(TRUE);
			}
			FreeDiskObject(DiskObject);
			return(FALSE);
		}
	}
	else if (!bool && Iconified) {
		CloseIcon();
		if (ActiveWindows & 1) SetUpWindow();
		if (ActiveWindows & 1<<1) SetUpInfoWindow();
		if (ActiveWindows & 1<<2) SetUpOptWindow();
	}
}


static void CarvHorLine(struct Window *W, int x, int y, int w) {

	SetDrMd(W->RPort, JAM2);
	SetAPen(W->RPort, ShadowPen);
	Move(W->RPort, x, y);
	Draw(W->RPort, x+w-1, y);
	SetAPen(W->RPort, ShinePen);
	Move(W->RPort, x, y+1);
	Draw(W->RPort, x+w-1, y+1);
}

static void MakeBox(struct Window *W, int x, int y, int w, int h) {

	ASSERT(W)

	SetDrMd(W->RPort, JAM2);
	SetAPen(W->RPort, ShadowPen);
	Move(W->RPort, x, y+h-1);
	Draw(W->RPort, x, y);
	Draw(W->RPort, x+w-1, y);
	Move(W->RPort, x+w-2, y+2);
	Draw(W->RPort, x+w-2, y+h-2);
	Draw(W->RPort, x+2, y+h-2);

	SetAPen(W->RPort, ShinePen);
	Move(W->RPort, x+1, y+h-1);
	Draw(W->RPort, x+1, y+1);
	Draw(W->RPort, x+w-1, y+1);
	Draw(W->RPort, x+w-1, y+h-1);
	Draw(W->RPort, x+1, y+h-1);
}

static void MakeNamedBox(struct Window *W, char *Name, int x, int y, int w, int h) {

	ASSERT(W)

	MakeBox(W, x, y, w, h);
	Move(W->RPort, x+(w-(TextLength(W->RPort, Name, strlen(Name))+2*TextLength(W->RPort, " ", 1)))/2, y+Font->tf_Baseline/2);
	SetDrMd(W->RPort, JAM2);
	SetAPen(W->RPort, ShadowPen);
	SetBPen(W->RPort, 0);
	Text(W->RPort, " ", 1);
	Text(W->RPort, Name, strlen(Name));
	Text(W->RPort, " ", 1);
}

/*
 *	  This set of routines draw the progress bar. They're fairly smart---
 *   first they update Bar, then they check for the layer we need being
 *   unlocked. If it's not the case, they set SomethingFailed go.
 *   As soon as the layer is free, the bar is redrawn basing on Bar.
 *   This allows for smooth copy operations even if someone uses menus
 *   (thus locking all layers). UpDateProgress forces the bar to be
 *   updated.
 */

static unsigned char SomethingFailed, SomethingMainFailed,
							MainBar[20], MainError[10], Bar[4][20],
							Error[4][40], CurrentListName;

static unsigned short int ColorToPen(unsigned char color) {

	ASSERT(color<4)

	if (color == 0) return(0);
	if (color == 1) return(ShadowPen);
	if (color == 2) return(ShinePen);
	if (color == 3) return(HighPen);

}

static void PrintMainRectAt(unsigned short Cyl, unsigned char color) {

	ASSERT(Cyl<80)
	ASSERT(Window[WIN_MAIN])

	SetDrMd(Window[WIN_MAIN]->RPort, JAM2);
	SetAPen(Window[WIN_MAIN]->RPort, ColorToPen(color));
	RectFill(Window[WIN_MAIN]->RPort, LeftBorder+2+(Cyl*(XSize*39-4))/80, TopBorder+YSize+1,
									LeftBorder+2+((Cyl+1)*(XSize*39-4))/80-1, TopBorder+(YSize*5)/2-2);
}

static void PrintMainErrorRectAt(unsigned short Cyl) {

	ASSERT(Cyl<80)
	ASSERT(Window[WIN_MAIN])

	SetDrMd(Window[WIN_MAIN]->RPort, JAM2);
	SetAPen(Window[WIN_MAIN]->RPort, 3);
	SetAfPt(Window[WIN_MAIN]->RPort, Pattern, 2-WidthFactor);

	RectFill(Window[WIN_MAIN]->RPort, LeftBorder+2+(Cyl*(XSize*39-4))/80, TopBorder+YSize+1,
									LeftBorder+2+((Cyl+1)*(XSize*39-4))/80-1, TopBorder+(YSize*5)/2-2);
	SetAfPt(Window[WIN_MAIN]->RPort, NULL, 0);
}

static void PrintRectAt(unsigned short Unit, unsigned short Cyl, unsigned char color) {

	ASSERT(Cyl<80)
	ASSERT(Window[WIN_INFO])

	SetDrMd(Window[WIN_INFO]->RPort, JAM2);
	SetAPen(Window[WIN_INFO]->RPort, ColorToPen(color));
	RectFill(Window[WIN_INFO]->RPort,
			LeftBorder+XSize*22+((Unit%2)*13+1)*YSize*WidthFactor+(Cyl%10)*YSize*WidthFactor, TopBorder+((Unit/2)*11+1)*YSize+2+(Cyl/10)*YSize,
			LeftBorder+XSize*22+((Unit%2)*13+1)*YSize*WidthFactor+(Cyl%10)*YSize*WidthFactor+YSize*WidthFactor-2, TopBorder+((Unit/2)*11+1)*YSize+2+(Cyl/10)*YSize+YSize-2);
}

static void PrintErrorRectAt(unsigned char Unit, unsigned short Track, unsigned short IsError) {

	short int i;

	ASSERT(Track<160)
	ASSERT(Window[WIN_INFO])

	SetAPen(Window[WIN_INFO]->RPort, 0);

	SetDrMd(Window[WIN_INFO]->RPort, JAM1);
	if (!IsError && (Track%2 || WidthFactor == 1)) SetDrPt(Window[WIN_INFO]->RPort, 0xAAAAUL);

	if (Track%2) {
		int Corr = (IsError && (Error[Unit][Track/4] & 2<<(2*((Track-1)%4))));
		Track /= 2;
		for(i=0; i<YSize-4+Corr+(WidthFactor == 2 && !IsError); i++) {
			Move(Window[WIN_INFO]->RPort, LeftBorder+XSize*22+((Unit%2)*13+1)*YSize*WidthFactor+(Track%10)*YSize*WidthFactor+(2+i-Corr)*WidthFactor, TopBorder+((Unit/2)*11+1)*YSize+2+(Track/10)*YSize+1+i);
			Draw(Window[WIN_INFO]->RPort, LeftBorder+XSize*22+((Unit%2)*13+1)*YSize*WidthFactor+(Track%10)*YSize*WidthFactor+YSize*WidthFactor-2-WidthFactor, TopBorder+((Unit/2)*11+1)*YSize+2+(Track/10)*YSize+1+i);
		}
	}
	else {
		Track /= 2;
		for(i=0; i<(YSize-3)*WidthFactor-1; i+=(WidthFactor == 2 && !IsError ? 2 : 1)) {
			Move(Window[WIN_INFO]->RPort,
			LeftBorder+XSize*22+((Unit%2)*13+1)*YSize*WidthFactor+(Track%10)*YSize*WidthFactor+i+WidthFactor,
			TopBorder+((Unit/2)*11+1)*YSize+2+(Track/10)*YSize+1+(i+1)/WidthFactor);
			Draw(Window[WIN_INFO]->RPort,
			LeftBorder+XSize*22+((Unit%2)*13+1)*YSize*WidthFactor+(Track%10)*YSize*WidthFactor+i+WidthFactor,
			TopBorder+((Unit/2)*11+1)*YSize+2+(Track/10)*YSize+YSize-3);
		}
	}
	SetDrPt(Window[WIN_INFO]->RPort, 0xFFFFUL);
}

void UpdateMainProgress(unsigned char Always) {

	unsigned short i;

	if (SomethingMainFailed || Always) {
		ObtainSemaphore(&Semaphore[WIN_MAIN]);
		if (Window[WIN_MAIN]) {

			for(i=0; i<80; i++) {
				PrintMainRectAt(i, (MainBar[i/4]>>(2*(i%4))) & 3);
				if (MainError[i/8] & 1<<(i%8)) PrintMainErrorRectAt(i);
			}

			SomethingMainFailed = 0;
		}
		ReleaseSemaphore(&Semaphore[WIN_MAIN]);
	}
}

void UpdateProgress(unsigned char Always) {

	unsigned short i;
	unsigned char Unit;

	if (SomethingFailed || Always) {
		ObtainSemaphore(&Semaphore[WIN_INFO]);
		if (Window[WIN_INFO]) {
			for(i=0; i<80; i++) {
				for(Unit=0; Unit<4; Unit++) {
					PrintRectAt(Unit, i, (Bar[Unit][i/4]>>(2*(i%4))) & 3);
					if (Error[Unit][i/2] & (2<<(2*((i*2)%4)))) PrintErrorRectAt(Unit, i*2, TRUE);
					else if (Error[Unit][i/2] & (1<<(2*((i*2)%4)))) PrintErrorRectAt(Unit, i*2, FALSE);
					if (Error[Unit][(i*2+1)/4] & (2<<(2*((i*2+1)%4)))) PrintErrorRectAt(Unit, i*2+1, TRUE);
					else if (Error[Unit][(i*2+1)/4] & (1<<(2*((i*2+1)%4)))) PrintErrorRectAt(Unit, i*2+1, FALSE);
				}
			}
			SomethingFailed = 0;
		}
		ReleaseSemaphore(&Semaphore[WIN_INFO]);
	}
}

void DrawMainProgress(unsigned short Cyl, unsigned char color) {

	if (Cyl<=79) {
		MainBar[Cyl/4] &= ~(3<<(2*(Cyl%4)));
		MainBar[Cyl/4] |= color<<(2*(Cyl%4));

		ObtainSemaphore(&Semaphore[WIN_MAIN]);
		if (Window[WIN_MAIN] && AttemptLockLayerRom(Window[WIN_MAIN]->WLayer)) {
			UpdateMainProgress(FALSE);
			PrintMainRectAt(Cyl, color);
			UnlockLayerRom(Window[WIN_MAIN]->WLayer);
		}
		else SomethingMainFailed = 1;

		ReleaseSemaphore(&Semaphore[WIN_MAIN]);
	}
}

void DrawProgress(unsigned char Unit, unsigned short Cyl, unsigned char color) {

	ASSERT(Cyl<80)

	if (Cyl<=79 && Unit<4) {
		Bar[Unit][Cyl/4] &= ~(3<<(2*(Cyl%4)));
		Bar[Unit][Cyl/4] |= color<<(2*(Cyl%4));

		ObtainSemaphore(&Semaphore[WIN_INFO]);
		if (Window[WIN_INFO] && AttemptLockLayerRom(Window[WIN_INFO]->WLayer)) {
			UpdateProgress(FALSE);
			PrintRectAt(Unit, Cyl, color);
			UnlockLayerRom(Window[WIN_INFO]->WLayer);
		}
		else SomethingFailed = 1;

		ReleaseSemaphore(&Semaphore[WIN_INFO]);
	}
}

/*
 *	  This routine wipes the progress bar.
 */

void WipeProgress(unsigned short start) {

	register unsigned short i,j;

	ASSERT(start<80)

	for(i=start/8+1; i<10; i++) MainError[i] = 0;
	MainError[start/8] &= (1<<(start%8))-1;
	for(i=start/4+1; i<20; i++) MainBar[i] = 0;
	MainBar[start/4] &= (1<<((start%4)*2))-1;

	ObtainSemaphore(&Semaphore[WIN_MAIN]);

	if (Window[WIN_MAIN]) {
		SetDrMd(Window[WIN_MAIN]->RPort, JAM2);
		SetAPen(Window[WIN_MAIN]->RPort, 0);
		RectFill(Window[WIN_MAIN]->RPort, LeftBorder+2+(start*(XSize*39-4))/80, TopBorder+YSize+1, LeftBorder+XSize*39+2-5, TopBorder+(YSize*5)/2-2);
	}

	ReleaseSemaphore(&Semaphore[WIN_MAIN]);

	ObtainSemaphore(&Semaphore[WIN_INFO]);

	if (Window[WIN_INFO]) {
		SetDrMd(Window[WIN_INFO]->RPort, JAM2);
		SetAPen(Window[WIN_INFO]->RPort, 0);
	}

	for(j=0; j<4; j++) {
		for(i=start/4+1; i<20; i++) Bar[j][i] = 0;
		Bar[j][start/4] &= (1<<((start%4)*2))-1;

		for(i=start/2+1; i<40; i++) Error[j][i] = 0;
		Error[j][start/2] &= (1<<(((start*2)%4)*2))-1;

		if (Window[WIN_INFO]) {
			if (start%10)
				RectFill(Window[WIN_INFO]->RPort,
							LeftBorder+XSize*22+((j%2)*13+1)*YSize*WidthFactor+(start%10)*YSize*WidthFactor, TopBorder+((j/2)*11+1)*YSize+2+(start/10)*YSize,
							LeftBorder+XSize*22+((j%2)*13+1)*YSize*WidthFactor+9*YSize*WidthFactor+YSize*WidthFactor-2, TopBorder+((j/2)*11+1)*YSize+2+(start/10)*YSize+YSize-2);
			if (start<=70)
				RectFill(Window[WIN_INFO]->RPort,
							LeftBorder+XSize*22+((j%2)*13+1)*YSize*WidthFactor, TopBorder+((j/2)*11+1)*YSize+2+((start+9)/10)*YSize,
							LeftBorder+XSize*22+((j%2)*13+1)*YSize*WidthFactor+10*YSize*WidthFactor-2, TopBorder+((j/2)*11+1)*YSize+2+7*YSize+YSize-2);
		}
	}
	ReleaseSemaphore(&Semaphore[WIN_INFO]);
}



static void UpdateElapsedString(void) {

	struct EClockVal EClock = LastEClock;
	unsigned long i;

	i = ((UWORD *)(&EClock))[3]*1000L;
	((UWORD *)(&EClock))[3] = i;
	i = ((UWORD *)(&EClock))[2]*1000L+i/65536UL;
	((UWORD *)(&EClock))[2] = i;
	i = ((UWORD *)(&EClock))[1]*1000L+i/65536UL;
	((UWORD *)(&EClock))[1] = i;
	i = ((UWORD *)(&EClock))[0]*1000L+i/65536UL;
	((UWORD *)(&EClock))[0] = i;

	i = EClock.ev_lo/SysBase->ex_EClockFrequency+(EClock.ev_hi%SysBase->ex_EClockFrequency)*(0xFFFFFFFFUL/SysBase->ex_EClockFrequency);
	sprintf(ElapsedString, "%ld.%03ld", i/1000UL, i%1000UL);

}


/* This function sets the window size in a smart way. If the window is not
open, its Pos[] vector is set. */

void ChangeWindowSize(unsigned short i, int LeftEdge, int TopEdge) {

	if (Window[i]) {
		ChangeWindowBox(Window[i], LeftEdge<0 ? Window[i]->LeftEdge : LeftEdge, TopEdge<0 ? Window[i]->TopEdge : TopEdge, Window[i]->Width, Window[i]->Height);
	}
	else {
		if (LeftEdge >= 0) Pos[i][0] = LeftEdge;
		if (TopEdge >= 0) Pos[i][1] = TopEdge;
	}
}


void ZoomWindow(int WindowNumber, int op) {

	if (op == -1 || (Window[WindowNumber] ? (((Window[WindowNumber]->Flags & WFLG_ZOOMED) != 0) != ZoomIsLarge[WindowNumber]) : Zoomed[WindowNumber]) != op) {
		if (Window[WindowNumber]) ZipWindow(Window[WindowNumber]);
		Zoomed[WindowNumber] = !Zoomed[WindowNumber];
	}
}


/* This function rebuilds the window cosmetics basing itself on the
	internal storage.  */

static void UpdateWindow(int WindowNumber) {

	int i;
	struct Window *W = Window[WindowNumber];

	ObtainSemaphore(&Semaphore[WindowNumber]);

	switch(WindowNumber) {

		case WIN_MAIN:
			DrawBevelBox(W->RPort, LeftBorder, TopBorder+YSize, XSize*39, (YSize*3)/2, GT_VisualInfo, VisualInfo, GTBB_Recessed, (ULONG)TRUE, TAG_DONE);
			MakeNamedBox(W, "Mode", LeftBorder+XSize*56, TopBorder, XSize*15, YSize*9);
			MakeNamedBox(W, "Src/Dest", LeftBorder+XSize*40+XSize/2, TopBorder, XSize*13+XSize/2, YSize*9);
			CarvHorLine(W, LeftBorder, TopBorder, XSize*39);
			CarvHorLine(W, LeftBorder, TopBorder+YSize*9-2, XSize*39);
			Move(W->RPort, LeftBorder+(XSize*39-(TextLength(W->RPort, " Control Panel ", strlen(" Control Panel "))))/2, TopBorder+Font->tf_Baseline/2);
			SetDrMd(W->RPort, JAM2);
			SetAPen(W->RPort, ShadowPen);
			SetBPen(W->RPort, 0);
			Text(W->RPort, " Control Panel ", strlen(" Control Panel "));
			break;

		case WIN_INFO:
			for(i=0; i<4; i++) {
				DrawBevelBox(W->RPort,
							LeftBorder+XSize*22+((i%2)*13+1)*YSize*WidthFactor-3, TopBorder+((i/2)*11+1)*YSize,
							YSize*10*WidthFactor+4+1, YSize*8+2+1, GT_VisualInfo, VisualInfo, GTBB_Recessed, (ULONG)TRUE, TAG_DONE);
				MakeNamedBox(W, df[i],
							LeftBorder+XSize*22+((i%2)*13)*YSize*WidthFactor, TopBorder+((i/2)*11)*YSize,
							YSize*12*WidthFactor-1, YSize*10);
			}

			MakeBox(W, LeftBorder, TopBorder, XSize*20, YSize*7+YSize/2);
			break;

		case WIN_OPTIONS:
			MakeNamedBox(W, "Switches", LeftBorder, TopBorder, XSize*33, YSize*11);
			MakeNamedBox(W, "Virtual Disk", LeftBorder, TopBorder+YSize*12+YSize/2, XSize*33, YSize*3);
			MakeNamedBox(W, "Options", LeftBorder+XSize*35, TopBorder, XSize*24, YSize*15+YSize/2);
			CarvHorLine(W, LeftBorder+XSize*35+2, TopBorder+YSize*8, XSize*24-4);
			break;

	}

	ReleaseSemaphore(&Semaphore[WindowNumber]);
}


void RefreshWindow(int WindowNumber) {

	ASSERT(WindowNumber >= 0);
	ASSERT(WindowNumber < WIN_COUNT);

	if (Window[WindowNumber]) {
		ObtainSemaphore(&Semaphore[WindowNumber]);

		GT_BeginRefresh(Window[WindowNumber]);
		UpdateWindow(WindowNumber);
		GT_EndRefresh(Window[WindowNumber], TRUE);

		if (WindowNumber == WIN_MAIN) UpdateMainProgress(TRUE);
		if (WindowNumber == WIN_INFO) UpdateProgress(TRUE);

		ReleaseSemaphore(&Semaphore[WindowNumber]);
	}
}


static void ExchangeZoomPos(int WindowNumber) {

	register int i, t;

	for(i=0; i<4; i++) {
		t = Pos[WindowNumber][i];
		Pos[WindowNumber][i] = ZoomPos[WindowNumber][i];
		ZoomPos[WindowNumber][i] = t;
	}

	ZoomIsLarge[WindowNumber] = 1;
}

/*
 * This sets up the main window. Sets also the pen values, font etc.
 */
char SetUpWindow(void) {

	static ShownStarTrek;

	struct Screen *PubScreenLock = NULL;
	struct NewGadget ng;
	struct DisplayInfo DisplayInfo;
	struct Gadget *g;
	register unsigned short i;
	struct DrawInfo *di;

	if (Window[WIN_MAIN]) {
		WindowToFront(Window[WIN_MAIN]);
		return(TRUE);
	}

	if (!SysKilled) {
		if (!(PubScreenLock = LockPubScreen(PubScreen))) return(0);
		Screen = PubScreenLock;
	}

	CloseIcon();

	WidthFactor = 1;
	if (GetDisplayInfoData(NULL, (APTR)&DisplayInfo, sizeof(DisplayInfo), DTAG_DISP, GetVPModeID(&Screen->ViewPort))) {
		if (DisplayInfo.Resolution.y/DisplayInfo.Resolution.x == 2) WidthFactor = 2;
	}

	if (VisualInfo = GetVisualInfoA(Screen, NULL)) {

		if (Font = OpenFont(Screen->Font)) {
			TextAttr = Screen->Font;
			XSize = Font->tf_XSize;
			YSize = Font->tf_YSize;

			TopBorder = Screen->WBorTop+YSize+1+YSize/2;
			LeftBorder = Screen->WBorLeft+XSize;

			if (69*XSize+Screen->WBorLeft+Screen->WBorRight > Screen->Width ||
				24*XSize+25*YSize*WidthFactor+Screen->WBorLeft+Screen->WBorRight > Screen->Width ||
				YSize*22+TopBorder+Screen->WBorBottom > Screen->Height) {
				CloseFont(Font);
				TextAttr = &Topaz8;
				Font = OpenFont(&Topaz8);
				TopBorder = TopBorder-YSize/2+4;
				LeftBorder = LeftBorder-XSize+8;
				XSize = YSize = 8;
			}

			if (di = GetScreenDrawInfo(Screen)) {
				ShinePen = di->dri_Pens[SHINEPEN];
				ShadowPen = di->dri_Pens[SHADOWPEN];
				HighPen = di->dri_Pens[FILLPEN];
				FreeScreenDrawInfo(Screen, di);

				setmem(&ng, sizeof(ng), 0);

				ZoomPos[WIN_MAIN][0] = Pos[WIN_MAIN][0];
				ZoomPos[WIN_MAIN][1] = Pos[WIN_MAIN][1];
				ZoomPos[WIN_MAIN][2] = LeftBorder*2+XSize*39;
				ZoomPos[WIN_MAIN][3] = TopBorder+YSize*7;

				Pos[WIN_MAIN][2] = 73*XSize+Screen->WBorLeft+Screen->WBorRight;
				Pos[WIN_MAIN][3] = YSize*10+Screen->WBorBottom+Screen->WBorTop+YSize+1;

				ng.ng_TextAttr = TextAttr;
				ng.ng_VisualInfo = VisualInfo;

				if (g = CreateContext(&GList[WIN_MAIN])) {

					ng.ng_LeftEdge	=	LeftBorder+XSize*41+XSize/2;
					ng.ng_TopEdge	=	TopBorder+YSize;
					ng.ng_Width		=	XSize*3;
					ng.ng_Height	=	(YSize*3)/2;
					ng.ng_Flags		=	PLACETEXT_RIGHT;

					if (GfxBase->LibNode.lib_Version<39) {
						ng.ng_LeftEdge	+=	(ng.ng_Width-CHECKBOX_WIDTH)/2;
						ng.ng_TopEdge	+=	(ng.ng_Height-CHECKBOX_HEIGHT)/2;
					}

					for(i=DF0S; i<=DF3S; i++) {
						ng.ng_GadgetText	=	GadgetText[i];
						ng.ng_GadgetID		=	i;
						Gadget[i] = g = CreateGadget(CHECKBOX_KIND, g, &ng, GT_Underscore, (ULONG)'_', GTCB_Scaled, (ULONG)TRUE, GTCB_Checked, (ULONG)GadgetState[i], TAG_DONE);
						ng.ng_TopEdge		+=	YSize*2;
					}

					ng.ng_LeftEdge		=	LeftBorder+XSize*50;
					ng.ng_TopEdge		=	TopBorder+YSize;
					ng.ng_GadgetText	=	"";

					if (GfxBase->LibNode.lib_Version<39) {
						ng.ng_LeftEdge	+=	(ng.ng_Width-CHECKBOX_WIDTH)/2;
						ng.ng_TopEdge	+=	(ng.ng_Height-CHECKBOX_HEIGHT)/2;
					}

					for(i=DF0D; i<=DF3D; i++) {
						ng.ng_GadgetID		=	i;
						Gadget[i] = g = CreateGadget(CHECKBOX_KIND, g, &ng, GT_Underscore, (ULONG)'_', GTCB_Scaled, (ULONG)TRUE, GTCB_Checked, (ULONG)GadgetState[i], TAG_DONE);
						ng.ng_TopEdge		+=	YSize*2;
					}

					ng.ng_TopEdge	=	TopBorder+YSize*3;
					ng.ng_Flags		=	0;
					ng.ng_Width		=	XSize*9;
					ng.ng_Height	=	(YSize*3)/2;

					for(i=STOP; i<=ICONIFY; i++) {
						ng.ng_TopEdge	=	TopBorder+YSize*(3+2*((i-STOP)/4));
						ng.ng_LeftEdge		=	LeftBorder+(XSize*10)*((i-STOP)%4);
						ng.ng_GadgetText	=	(i == NOWB && SysKilled) ? "WB" : GadgetText[i];
						ng.ng_GadgetID		=	i;
						Gadget[i] = g = CreateGadget(BUTTON_KIND, g, &ng, GT_Underscore, (ULONG)'_', TAG_DONE);
					}

					ng.ng_LeftEdge	=	XSize*69;
					ng.ng_TopEdge	=	TopBorder+YSize;
					ng.ng_Width		=	YSize*WidthFactor;
					ng.ng_Height	=	YSize;

					ng.ng_TopEdge	+=	((GfxBase->LibNode.lib_Version<39) ? (CHECKBOX_HEIGHT-MX_HEIGHT)/2 : YSize/4);

					ng.ng_GadgetText	=	"Copy Mode";
					ng.ng_GadgetID		=	COPYMODE;
					ng.ng_Flags			=	PLACETEXT_LEFT;
					Gadget[COPYMODE] = g = CreateGadget(MX_KIND, g, &ng, GTMX_Scaled, (ULONG)TRUE, GTMX_Spacing, (ULONG)YSize, GTMX_Labels, &GadgetText[COPYMODE], GTMX_Active, (ULONG)CopyMode, TAG_DONE);

					if (Zoomed[WIN_MAIN]) ExchangeZoomPos(WIN_MAIN);
					else ZoomIsLarge[WIN_MAIN] = 0;

					ObtainSemaphore(&Semaphore[WIN_MAIN]);

					if (Window[WIN_MAIN] = OpenWindowTags(NULL,
						WA_Left, (ULONG)Pos[WIN_MAIN][0],
						WA_Top, (ULONG)Pos[WIN_MAIN][1],
						WA_Width, (ULONG)Pos[WIN_MAIN][2],
						WA_Height, (ULONG)Pos[WIN_MAIN][3],
						WA_IDCMP, (ULONG)(MXIDCMP|BUTTONIDCMP|CHECKBOXIDCMP|IDCMP_CLOSEWINDOW|IDCMP_REFRESHWINDOW|IDCMP_RAWKEY),
						WA_Flags, (ULONG)(WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_ACTIVATE|((SysKilled || !SmartRefresh) ? WFLG_SIMPLE_REFRESH : WFLG_SMART_REFRESH)|WFLG_RMBTRAP),
						WA_Gadgets, GList[WIN_MAIN],
						WA_Title, Title,
						WA_ScreenTitle, ScreenTitle,
						WA_Zoom, ZoomPos[WIN_MAIN],
						WA_CustomScreen, Screen,
						WA_AutoAdjust,(ULONG)(TRUE),
						WA_RptQueue, (ULONG)(1),
						TAG_DONE)) {

						Window[WIN_MAIN]->UserData = (void *)WIN_MAIN;
						SetFont(Window[WIN_MAIN]->RPort, Font);
						ReleaseSemaphore(&Semaphore[WIN_MAIN]);
						ScreenToFront(Screen);
						GT_RefreshWindow(Window[WIN_MAIN],NULL);
						EnableGadgets(EnableState);
						UpdateWindow(WIN_MAIN);
						UpdateMainProgress(TRUE);
						if (PubScreenLock) UnlockPubScreen(NULL, PubScreenLock);
						OldWindowPtr = ((struct Process *)Me)->pr_WindowPtr;
						CopyTaskOldWindowPtr = ((struct Process *)Copier)->pr_WindowPtr;
						WindowPort = Window[WIN_MAIN]->UserPort;
						((struct Process *)Me)->pr_WindowPtr = ((struct Process *)Copier)->pr_WindowPtr = (APTR)Window[WIN_MAIN];

						if (!ShownStarTrek) {
							ShownStarTrek = TRUE;
							StarTrek();
						}
						return(TRUE);
					}
					ReleaseSemaphore(&Semaphore[WIN_MAIN]);
					FreeGadgets(GList[WIN_MAIN]);
					GList[WIN_MAIN] = NULL;
				}
			}
			CloseFont(Font);
			Font = NULL;
		}
		FreeVisualInfo(VisualInfo);
		VisualInfo = NULL;
	}

	if (PubScreenLock) UnlockPubScreen(NULL, PubScreenLock);
	return(FALSE);
}


/*
 * This sets up the options window.
 */
char SetUpOptWindow(void) {

	struct NewGadget ng;
	struct Gadget *g;
	register unsigned short i;

	if (Window[WIN_OPTIONS]) {
		WindowToFront(Window[WIN_OPTIONS]);
		return(TRUE);
	}

	if (!Window[WIN_MAIN] && !SetUpWindow()) return(0);

	setmem(&ng, sizeof(ng), 0);

	ZoomPos[WIN_OPTIONS][0] = Pos[WIN_OPTIONS][0];
	ZoomPos[WIN_OPTIONS][1] = Pos[WIN_OPTIONS][1];
	ZoomPos[WIN_OPTIONS][2] = LeftBorder*2+XSize*33;
	ZoomPos[WIN_OPTIONS][3] = TopBorder+YSize*11+XSize/WidthFactor+Screen->WBorBottom;

	Pos[WIN_OPTIONS][2] = 61*XSize+Screen->WBorLeft+Screen->WBorRight;
	Pos[WIN_OPTIONS][3] = YSize*16+YSize/2+Screen->WBorBottom+Screen->WBorTop+YSize+1;

	ng.ng_TextAttr = TextAttr;
	ng.ng_VisualInfo = VisualInfo;

	g = CreateContext(&GList[WIN_OPTIONS]);

	ng.ng_Flags		=	PLACETEXT_LEFT;
	ng.ng_Width		=	XSize*3;
	ng.ng_Height	=	(YSize*3)/2;
	ng.ng_TopEdge	=	TopBorder+YSize;
	ng.ng_LeftEdge	=	LeftBorder+XSize*14;

	if (GfxBase->LibNode.lib_Version<39) {
		ng.ng_LeftEdge	+=	(ng.ng_Width-CHECKBOX_WIDTH)/2;
		ng.ng_TopEdge	+=	(ng.ng_Height-CHECKBOX_HEIGHT)/2;
	}

	for(i=VERIFY; i<=AUTO; i++) {
		ng.ng_GadgetText	=	GadgetText[i];
		ng.ng_GadgetID		=	i;

		Gadget[i] = g = CreateGadget(CHECKBOX_KIND, g, &ng, GT_Underscore, (ULONG)'_', GTCB_Scaled, (ULONG)TRUE, GTCB_Checked, (ULONG)GadgetState[i], TAG_DONE);

		ng.ng_TopEdge	+=	YSize*2;

		if (i-VERIFY==4) {
			ng.ng_LeftEdge	+=	XSize*14;
			ng.ng_TopEdge	-=	YSize*10;
		}
	}

	ng.ng_LeftEdge	=	LeftBorder+XSize*46;
	ng.ng_TopEdge	=	TopBorder+(YSize*3)/2;
	ng.ng_Width		=	XSize*12;
	ng.ng_Height	=	(YSize*3)/2;

	for(i=LABEL; i<=VDNAME; i++) {
		ng.ng_GadgetText	=	GadgetText[i];
		ng.ng_GadgetID		=	i;

		if (i == VDNAME) {
			ng.ng_LeftEdge	=	LeftBorder+XSize*8;
			ng.ng_TopEdge	=	TopBorder+YSize*13+YSize/2;
		}

		Gadget[i] = g = CreateGadget(STRING_KIND, g, &ng, GT_Underscore, (ULONG)'_', GTST_String, GadgetString[i-LABEL], GTST_MaxChars, i == LABEL ? (ULONG)LABEL_STR_LEN : (i == FILENAME ? (ULONG)FILENAME_STR_LEN : (i == XPKLIB ? (ULONG)XPK_STR_LEN : (ULONG)VD_STR_LEN)), TAG_DONE);

		ng.ng_TopEdge	+=	YSize*2;
	}

	ng.ng_Width		=	XSize*6;
	ng.ng_LeftEdge	=	LeftBorder+XSize*26;
	ng.ng_TopEdge	=	TopBorder+YSize*13+YSize/2;

	for(i=VDNUMBER; i<=ECYL; i++) {

		ng.ng_GadgetText	=	GadgetText[i];
		ng.ng_GadgetID		=	i;

		Gadget[i] = g = CreateGadget(INTEGER_KIND, g, &ng, GT_Underscore, (ULONG)'_', GTIN_Number, (ULONG)GadgetNumber[i-VDNUMBER], GTIN_MaxChars, (ULONG)2, TAG_DONE);

		if (i == VDNUMBER) {
			ng.ng_LeftEdge	=	LeftBorder+XSize*52;
			ng.ng_TopEdge	=	TopBorder+YSize*7;
		}

		ng.ng_TopEdge	+=	YSize*2;
	}

	if (Zoomed[WIN_OPTIONS]) ExchangeZoomPos(WIN_OPTIONS);
	else ZoomIsLarge[WIN_OPTIONS] = 0;

	ObtainSemaphore(&Semaphore[WIN_OPTIONS]);

	if (Window[WIN_OPTIONS] = OpenWindowTags(NULL,
		WA_Left, (ULONG)Pos[WIN_OPTIONS][0],
		WA_Top, (ULONG)Pos[WIN_OPTIONS][1],
		WA_Width, (ULONG)Pos[WIN_OPTIONS][2],
		WA_Height, (ULONG)Pos[WIN_OPTIONS][3],
		WA_IDCMP, (ULONG)(NULL),
		WA_Flags, (ULONG)(WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_ACTIVATE|((SysKilled || !SmartRefresh) ? WFLG_SIMPLE_REFRESH : WFLG_SMART_REFRESH)|WFLG_RMBTRAP),
		WA_Gadgets, GList[WIN_OPTIONS],
		WA_Title, OptTitle,
		WA_ScreenTitle, ScreenTitle,
		WA_Zoom, ZoomPos[WIN_OPTIONS],
		WA_CustomScreen, Screen,
		WA_AutoAdjust,(ULONG)(TRUE),
		WA_RptQueue, (ULONG)(1),
		TAG_DONE)) {

		Window[WIN_OPTIONS]->UserData = (void *)WIN_OPTIONS;
		SetFont(Window[WIN_OPTIONS]->RPort, Font);
		Window[WIN_OPTIONS]->UserPort = Window[WIN_MAIN]->UserPort;
		ModifyIDCMP(Window[WIN_OPTIONS], INTEGERIDCMP|STRINGIDCMP|CHECKBOXIDCMP|IDCMP_CLOSEWINDOW|IDCMP_REFRESHWINDOW|IDCMP_RAWKEY);

		GT_RefreshWindow(Window[WIN_OPTIONS],NULL);
		EnableGadgets(EnableState);
		UpdateWindow(WIN_OPTIONS);
	}
	else {
		FreeGadgets(GList[WIN_OPTIONS]);
		GList[WIN_OPTIONS] = NULL;
	}
	ReleaseSemaphore(&Semaphore[WIN_OPTIONS]);

	return((char)(Window[WIN_OPTIONS] != 0));
}

/*
 * This sets up the information window.
 */
char SetUpInfoWindow(void) {

	struct NewGadget ng;
	struct Gadget *g;

	if (Window[WIN_INFO]) {
		WindowToFront(Window[WIN_INFO]);
		return(TRUE);
	}

	if (!Window[WIN_MAIN] && !SetUpWindow()) return(0);

	setmem(&ng, sizeof(ng), 0);

	ZoomPos[WIN_INFO][0] = Pos[WIN_INFO][0];
	ZoomPos[WIN_INFO][1] = Pos[WIN_INFO][1];
	ZoomPos[WIN_INFO][2] = LeftBorder*2+XSize*20;
	ZoomPos[WIN_INFO][3] = TopBorder+YSize*21+YSize/2+Screen->WBorBottom;

	Pos[WIN_INFO][2] = 24*XSize+25*YSize*WidthFactor+Screen->WBorLeft+Screen->WBorRight;
	Pos[WIN_INFO][3] = YSize*22+Screen->WBorBottom+Screen->WBorTop+YSize+1;

	ng.ng_TextAttr = TextAttr;
	ng.ng_VisualInfo = VisualInfo;

	g = CreateContext(&GList[WIN_INFO]);

	ng.ng_TopEdge		=	TopBorder+YSize;
	ng.ng_LeftEdge		=	LeftBorder+XSize*10;
	ng.ng_Width			=	XSize*9;
	ng.ng_Height		=	(YSize*3)/2;
	ng.ng_GadgetText	=	GadgetText[STATUS];
	ng.ng_Flags			=	0;
	ng.ng_GadgetID		=	STATUS;

	Gadget[STATUS] = g = CreateGadget(TEXT_KIND, g, &ng, GTTX_Border, (ULONG)TRUE, /*GTTX_Justification, (ULONG)GTJ_RIGHT, */GTTX_Text, StatusString, TAG_DONE);

	UpdateElapsedString();

	ng.ng_TopEdge		+=	YSize*2;
	ng.ng_GadgetText	=	GadgetText[ELAPSED];
	ng.ng_GadgetID		=	ELAPSED;

	Gadget[ELAPSED] = g = CreateGadget(TEXT_KIND, g, &ng, GTTX_Border, (ULONG)TRUE, /*GTTX_Justification, (ULONG)GTJ_RIGHT, */GTTX_Text, ElapsedString, TAG_DONE);

	ng.ng_TopEdge		+=	YSize*2;
	ng.ng_GadgetText	=	GadgetText[COPYNUMBER];
	ng.ng_GadgetID		=	COPYNUMBER;

	Gadget[COPYNUMBER] = g = CreateGadget(NUMBER_KIND, g, &ng, GTNM_Border, (ULONG)TRUE, /*GTNM_Justification, (ULONG)GTJ_RIGHT, */GTNM_Number, (ULONG)Copies, TAG_DONE);

	ng.ng_LeftEdge		=	LeftBorder;
	ng.ng_TopEdge		+=	YSize*3;
	ng.ng_Width			=	XSize*20;
	ng.ng_Height		=	YSize*13;
	ng.ng_GadgetText	=	"";
	ng.ng_GadgetID		=	DISKLIST;

	Gadget[DISKLIST] = g = CreateGadget(LISTVIEW_KIND, g, &ng, GTLV_ReadOnly, (ULONG)TRUE, GTLV_Labels, &DiskList, TAG_DONE);

	if (Zoomed[WIN_INFO]) ExchangeZoomPos(WIN_INFO);
	else ZoomIsLarge[WIN_INFO] = 0;

	ObtainSemaphore(&Semaphore[WIN_INFO]);

	if (Window[WIN_INFO] = OpenWindowTags(NULL,
		WA_Left, (ULONG)Pos[WIN_INFO][0],
		WA_Top, (ULONG)Pos[WIN_INFO][1],
		WA_Width, (ULONG)Pos[WIN_INFO][2],
		WA_Height, (ULONG)Pos[WIN_INFO][3],
		WA_IDCMP, (ULONG)(NULL),
		WA_Flags, (ULONG)(WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_ACTIVATE|((SysKilled || !SmartRefresh) ? WFLG_SIMPLE_REFRESH : WFLG_SMART_REFRESH)|WFLG_RMBTRAP),
		WA_Gadgets, GList[WIN_INFO],
		WA_Title, InfoTitle,
		WA_ScreenTitle, ScreenTitle,
		WA_Zoom, ZoomPos[WIN_INFO],
		WA_CustomScreen, Screen,
		WA_AutoAdjust,(ULONG)(TRUE),
		WA_RptQueue, (ULONG)(1),
		TAG_DONE)) {


		Window[WIN_INFO]->UserData = (void *)WIN_INFO;
		SetFont(Window[WIN_INFO]->RPort, Font);

		Window[WIN_INFO]->UserPort = Window[WIN_MAIN]->UserPort;

		ModifyIDCMP(Window[WIN_INFO], LISTVIEWIDCMP|IDCMP_CLOSEWINDOW|IDCMP_REFRESHWINDOW|IDCMP_RAWKEY);

		GT_RefreshWindow(Window[WIN_INFO],NULL);
		EnableGadgets(EnableState);

		UpdateWindow(WIN_INFO);
		UpdateProgress(TRUE);
	}
	else {
		FreeGadgets(GList[WIN_INFO]);
		GList[WIN_INFO] = NULL;
	}
	ReleaseSemaphore(&Semaphore[WIN_INFO]);

	return((char)(Window[WIN_INFO] != 0));
}



/* The star-trek like bar effect */

void StarTrek(void) {

	register unsigned short i;

	if (!Window) return;
	for(i=0; i<80; i++) {
		DrawMainProgress(i, 3);
		TimerWait(1000);
	}
	for(i=0; i<80; i++) {
		DrawMainProgress(i, 0);
		TimerWait(1000);
	}
	UpdateMainProgress(FALSE);
}


void NextWindow(int WindowNumber, int dir) {
	int i, n;

	for(i=1; i<=WIN_COUNT; i++)
		if (Window[n = (WindowNumber+WIN_COUNT+i*dir)%WIN_COUNT]) {
			WindowToFront(Window[n]);
			ActivateWindow(Window[n]);
			return;
		}

	ASSERT(FALSE)
}

/* These functions handle the name list */

void AddName(unsigned char *Name) {

	struct Node *Node;

	if (Node = AllocVec(sizeof(struct Node)+MAXLISTWIDTH+1, MEMF_PUBLIC | MEMF_CLEAR)) {
		ObtainSemaphore(&Semaphore[WIN_INFO]);

		if (Window[WIN_INFO])
			GT_SetGadgetAttrs(Gadget[DISKLIST], Window[WIN_INFO], NULL, GTLV_Labels, ~0L, TAG_DONE);

		strncpy(Node->ln_Name = (char *)&Node[1], Name, MAXLISTWIDTH);
		AddHead(&DiskList, Node);

		if (Window[WIN_INFO])
			GT_SetGadgetAttrs(Gadget[DISKLIST], Window[WIN_INFO], NULL, GTLV_Labels, &DiskList, TAG_DONE);

		ReleaseSemaphore(&Semaphore[WIN_INFO]);
	}
}

void ChangeName(unsigned char *Name) {

	ObtainSemaphore(&Semaphore[WIN_INFO]);

	if (Window[WIN_INFO])
		GT_SetGadgetAttrs(Gadget[DISKLIST], Window[WIN_INFO], NULL, GTLV_Labels, ~0L, TAG_DONE);

	strncpy(DiskList.lh_Head->ln_Name, Name, MAXLISTWIDTH);

	if (Window[WIN_INFO])
		GT_SetGadgetAttrs(Gadget[DISKLIST], Window[WIN_INFO], NULL, GTLV_Labels, &DiskList, TAG_DONE);

	ReleaseSemaphore(&Semaphore[WIN_INFO]);
}

void FreeDiskList(void) {
	struct Node *n = DiskList.lh_Head, *m;

	while(n->ln_Succ) {
		m = n->ln_Succ;
		FreeVec(n);
		n = m;
	}
}


/* Functions to output elapsed time etc. */

void WriteElapsed(struct EClockVal *a) {

	ReadEClock(&LastEClock);

	LastEClock.ev_hi = LastEClock.ev_hi - a->ev_hi - (LastEClock.ev_lo < a->ev_lo);
	LastEClock.ev_lo = LastEClock.ev_lo < a->ev_lo ? 0xFFFFFFFFUL - (a->ev_lo - LastEClock.ev_lo) : LastEClock.ev_lo - a->ev_lo;

	UpdateElapsedString();

	ObtainSemaphore(&Semaphore[WIN_INFO]);

	if (Window[WIN_INFO] && AttemptLockLayerRom(Window[WIN_INFO]->WLayer)) {
		GT_SetGadgetAttrs(Gadget[ELAPSED], Window[WIN_INFO], NULL, GTTX_Text, ElapsedString, TAG_DONE);
		UnlockLayerRom(Window[WIN_INFO]->WLayer);
	}

	ReleaseSemaphore(&Semaphore[WIN_INFO]);
}


void UpdateElapsed(void) {

	ObtainSemaphore(&Semaphore[WIN_INFO]);

	if (Window[WIN_INFO])
		GT_SetGadgetAttrs(Gadget[ELAPSED], Window[WIN_INFO], NULL, GTTX_Text, ElapsedString, TAG_DONE);

	ReleaseSemaphore(&Semaphore[WIN_INFO]);
}


void WriteRetriesErrors(unsigned char Unit, unsigned short Track, int WriteError) {

	ASSERT(Track<160)

	if (Track>=160) return;

	ObtainSemaphore(&Semaphore[WIN_INFO]);
	ObtainSemaphore(&Semaphore[WIN_MAIN]);

	if (WriteError) {
		if (Window[WIN_INFO]) PrintErrorRectAt(Unit, Track, TRUE);
		if (Window[WIN_MAIN]) PrintMainErrorRectAt(Track/2);

		Error[Unit][Track/4] |= 2<<(Track%4)*2;
		MainError[Track/16] |= 1<<((Track/2)%8);
	}
	else {
		Error[Unit][Track/4] |= 1<<(Track%4)*2;
		if (Window[WIN_INFO]) PrintErrorRectAt(Unit, Track, FALSE);
	}

	ReleaseSemaphore(&Semaphore[WIN_MAIN]);
	ReleaseSemaphore(&Semaphore[WIN_INFO]);
}

void WriteCopies(void) {
	ObtainSemaphore(&Semaphore[WIN_INFO]);
	if (Window[WIN_INFO]) GT_SetGadgetAttrs(Gadget[COPYNUMBER], Window[WIN_INFO], NULL, GTNM_Number, (ULONG)Copies, TAG_DONE);
	ReleaseSemaphore(&Semaphore[WIN_INFO]);
}

void WriteStatus(char *Status) {
	strcpy(StatusString, Status);
	ObtainSemaphore(&Semaphore[WIN_INFO]);
	if (Window[WIN_INFO]) GT_SetGadgetAttrs(Gadget[STATUS], Window[WIN_INFO], NULL, GTTX_Text, StatusString, TAG_DONE);
	ReleaseSemaphore(&Semaphore[WIN_INFO]);
}

/*
 * This routines selects or delects a gadget.
 */

void SelectGadget(unsigned char GadgetNumber, unsigned char Bool) {
	if (GadgetNumber>=DF0S && GadgetNumber<=DF3D || GadgetNumber>=VERIFY && GadgetNumber<=AUTO) {
		GadgetState[GadgetNumber] = Bool;

		ObtainSemaphore(&Semaphore[WIN_MAIN]);
		ObtainSemaphore(&Semaphore[WIN_OPTIONS]);

		if (GadgetWindow(GadgetNumber))
			GT_SetGadgetAttrs(Gadget[GadgetNumber], GadgetWindow(GadgetNumber), NULL, GTCB_Checked, (ULONG)GadgetState[GadgetNumber], TAG_DONE);

		ReleaseSemaphore(&Semaphore[WIN_OPTIONS]);
		ReleaseSemaphore(&Semaphore[WIN_MAIN]);
	}
}


/*
 * This routines toggles a gadget.
 */

void ToggleGadget(unsigned char GadgetNumber) {
	if (GadgetNumber>=DF0S && GadgetNumber<=DF3D || GadgetNumber>=VERIFY && GadgetNumber<=AUTO)
		SelectGadget(GadgetNumber, !GadgetState[GadgetNumber]);
}

/* Returns the gadget with a certain shortcut */

short Op2Gadget(unsigned char Op) {

	short i;
	for(i=0; i<sizeof(GadgetKey)-1; i++) if (GadgetKey[i] == Op) return(i);
	return(-1);
}



/*
 * EnableGadgets takes a mask of bits and sets
 * all of the gadgets accordingly. Notice that we skip all gadges which
 * are never disabled.
 * Notice also that the Mask is memorized so that we can correctly open a new window.
 */

void EnableGadgets(ULONG Mask) {

	int i,j;

	EnableState = Mask;

	ObtainSemaphore(&Semaphore[WIN_MAIN]);
	ObtainSemaphore(&Semaphore[WIN_OPTIONS]);

	for(i=DF0S, j=0; i<=ECYL; (i == SAVECONF-1 || i == OPTIONS-1 || i == TALK-1 ? i += 3 : i++), j++) {
		if (GadgetWindow(i))
			GT_SetGadgetAttrs(Gadget[i], GadgetWindow(i), NULL, GA_Disabled, (ULONG)(!((Mask>>j)&1)), TAG_DONE);
	}

	ReleaseSemaphore(&Semaphore[WIN_OPTIONS]);
	ReleaseSemaphore(&Semaphore[WIN_MAIN]);
}

unsigned char GadgetEnabled(unsigned short n) {

	int i,j;

	if (n ==INFO || n == OPTIONS || n == SAVECONF || n == ICONIFY || n>=TALK && n<=AUTO || n == COPYMODE) return(TRUE);
	for(i=DF0S, j=0; i<n; (i == SAVECONF-1 || i == OPTIONS-1 || i == TALK-1 ? i += 3 : i++), j++);
	return((unsigned char)((EnableState>>j) & 1));
}


void SetGadgetState(unsigned short n) {

	if (n>=DF0S && n<=DF3D || n>=VERIFY && n<=AUTO) GadgetState[n] = ((Gadget[n]->Flags & SELECTED) != 0);
	else if (n>=VDNUMBER && n<=ECYL) GadgetNumber[n-VDNUMBER] = (unsigned long)((struct StringInfo *)(Gadget[n]->SpecialInfo))->LongInt > 99 ? 99 : (unsigned long)((struct StringInfo *)(Gadget[n]->SpecialInfo))->LongInt;
	else if (n>=LABEL && n<=VDNAME) 	strcpy(GadgetString[n-LABEL], ((struct StringInfo *)(Gadget[n]->SpecialInfo))->Buffer);
}

unsigned short GetGadgetState(unsigned short n) {

	if (n<LABEL) return(GadgetState[n]);
	else return(0);
}

/* This functions set/get the content of a string/integer gadget. They correctly
	handle the NOGUI case. Also, they are callable from both processes. */

static unsigned char SetGadgetBuffer(unsigned short int GN, unsigned char *p) {

	if (GN<LABEL || GN>VDNAME || !GadgetEnabled(GN)) return(1);
	strncpy(GadgetString[GN-LABEL], p, 30);
	ObtainSemaphore(&Semaphore[WIN_OPTIONS]);
	if (Window[WIN_OPTIONS])
		GT_SetGadgetAttrs(Gadget[GN], Window[WIN_OPTIONS], NULL, GTST_String, GadgetString[GN-LABEL], TAG_DONE);
	ReleaseSemaphore(&Semaphore[WIN_OPTIONS]);
	return(0);
}

static unsigned char *GetGadgetBuffer(unsigned short int GN) {

	if (GN<LABEL || GN>VDNAME) return("");
	return(GadgetString[GN-LABEL]);
}

static unsigned char SetGadgetNumber(unsigned short int GN, unsigned short n) {

	if (GN<VDNUMBER || GN>ECYL || !GadgetEnabled(GN)) return(1);
	GadgetNumber[GN-VDNUMBER] = n > 99 ? 99 : n;
	ObtainSemaphore(&Semaphore[WIN_OPTIONS]);
	if (Window[WIN_OPTIONS])
		GT_SetGadgetAttrs(Gadget[GN], Window[WIN_OPTIONS], NULL, GTIN_Number, (ULONG)n, TAG_DONE);
	ReleaseSemaphore(&Semaphore[WIN_OPTIONS]);
	return(0);
}

static unsigned short GetGadgetNumber(unsigned short int GN) {

	if (GN<VDNUMBER || GN>ECYL) return(0);
	return(GadgetNumber[GN-VDNUMBER]);
}

/* These are the specific calls for specific gadgets */

unsigned char SetBufferName(unsigned char *p) {
	return(SetGadgetBuffer(FILENAME, p));
}

unsigned char *GetBufferName(void) {
	return(GetGadgetBuffer(FILENAME));
}

unsigned char SetXPKLibName(unsigned char *p) {
	return(SetGadgetBuffer(XPKLIB, p));
}

unsigned char *GetXPKLibName(void) {
	return(GetGadgetBuffer(XPKLIB));
}

unsigned char SetDeviceName(unsigned char *p) {
	return(SetGadgetBuffer(VDNAME, p));
}

unsigned char SetDiskName(unsigned char *p) {
	return(SetGadgetBuffer(LABEL, p));
}

unsigned char *GetDeviceName(void) {
	return(GetGadgetBuffer(VDNAME));
}


unsigned char *GetDiskName(void) {
	return(GetGadgetBuffer(LABEL));
}

unsigned short GetRetryNumber(void) {
	return(GetGadgetNumber(RETRY));
}

unsigned short GetVDNumber(void) {
	return(GetGadgetNumber(VDNUMBER));
}

unsigned char SetRetryNumber(unsigned short n) {
	return(SetGadgetNumber(RETRY, n));
}

unsigned char SetVDNumber(unsigned short n) {
	return(SetGadgetNumber(VDNUMBER, n));
}

unsigned short GetSCyl(void) {
	return(GetGadgetNumber(SCYL));
}

unsigned short GetECyl(void) {
	return(GetGadgetNumber(ECYL));
}

unsigned char SetSCyl(unsigned short n) {
	return(SetGadgetNumber(SCYL,n));
}

unsigned char SetECyl(unsigned short n) {
	return(SetGadgetNumber(ECYL,n));
}

void SetCopyMode(unsigned char Mode) {
	CopyMode = Mode;
	ObtainSemaphore(&Semaphore[WIN_MAIN]);
	if (Window[WIN_MAIN])
		GT_SetGadgetAttrs(Gadget[COPYMODE], Window[WIN_MAIN], NULL, GTMX_Active, (ULONG)(CopyMode), TAG_DONE);
	ReleaseSemaphore(&Semaphore[WIN_MAIN]);
}

/* Here we deselect all disk gadgets */

void DeselectDiskGadgets(void) {

	register unsigned short i;
	for(i=DF0S; i<=DF3D; i++) SelectGadget(i, FALSE);
}

void ActivateStringGadget(unsigned char GadgetNumber) {

	ObtainSemaphore(&Semaphore[WIN_OPTIONS]);
	if (Window[WIN_OPTIONS])
		if (GadgetNumber<GADGET_COUNT && !(Gadget[GadgetNumber]->Flags & GADGDISABLED)) {
			ActivateWindow(Window[WIN_OPTIONS]);
			ActivateGadget(Gadget[GadgetNumber], Window[WIN_OPTIONS], NULL);
		}
	ReleaseSemaphore(&Semaphore[WIN_OPTIONS]);
}

/* Here we increment the disk name */

void IncrementDiskName(void) {

	unsigned short carry = 1;
	unsigned char *p, *q;

	if (!GadgetString[0][0]) return;
	p = GadgetString[0]+strlen(GadgetString[0])-1;
	while(p>=GadgetString[0] && (*p<'0' || *p>'9')) p--;
	if (p<GadgetString[0]) return;
	q = p;
	while(p>=GadgetString[0] && *p>='0' && *p<='9') p--;
	while(q>p) {
		if (carry = ((*q += carry) == '9'+1)) *q = '0';
		q--;
	}
	ObtainSemaphore(&Semaphore[WIN_OPTIONS]);
	if (Window[WIN_OPTIONS])
		GT_SetGadgetAttrs(Gadget[LABEL], Window[WIN_OPTIONS], NULL, GTST_String, GadgetString[0], TAG_DONE);
	ReleaseSemaphore(&Semaphore[WIN_OPTIONS]);
}

void SaveWindowConfig(BPTR h) {

	int i;

	FPrintf(h, NOWB_COMMAND" %s\n", SysKilled ? "On" : "Off");
	FPrintf(h, ICONIFY_COMMAND" %s\n", Iconified ? "On" : "Off");

	for(i=0; i<WIN_COUNT; i++) {
		FPrintf(h, WINDOW_COMMAND " %s %sLeftEdge %ld TopEdge %ld\n",
				WindowName[i],
				(Window[i] ? (((Window[i]->Flags & WFLG_ZOOMED) != 0) != ZoomIsLarge[i]) : Zoomed[i]) ? "Min " : "",
				Window[i] ? (ULONG)Window[i]->LeftEdge : (ULONG)Pos[i][0],
				Window[i] ? (ULONG)Window[i]->TopEdge :  (ULONG)Pos[i][1]
				);
	}

	for(i=0; i<WIN_COUNT; i++)
		if (Window[i])
			FPrintf(h, WINDOW_COMMAND " %s Open\n", WindowName[i]);

	FPrintf(h, PRINTERRORS_COMMAND" %s\n", GetGadgetState(PRINTERRORS) ? "On" : "Off");
	FPrintf(h, DATE_COMMAND" %s\n", GetGadgetState(DATE) ? "On" : "Off");
	FPrintf(h, VERIFY_COMMAND" %s\n", GetGadgetState(VERIFY) ? "On" : "Off");
	FPrintf(h, COMP_COMMAND" %s\n", GetGadgetState(COMPRESSION) ? "On" : "Off");
	FPrintf(h, INCNAME_COMMAND" %s\n", GetGadgetState(INCNAME) ? "On" : "Off");
	FPrintf(h, FFS_COMMAND" %s\n", GetGadgetState(FFS) ? "On" : "Off");
	FPrintf(h, INTL_COMMAND" %s\n", GetGadgetState(INTL) ? "On" : "Off");
	FPrintf(h, DIRCACHE_COMMAND" %s\n", GetGadgetState(DIRCACHE) ? "On" : "Off");
	FPrintf(h, TALK_COMMAND" %s\n", GetGadgetState(TALK) ? "On" : "Off");
	FPrintf(h, AUTO_COMMAND" %s\n", GetGadgetState(AUTO) ? "On" : "Off");

	FPrintf(h, SCYL_COMMAND" %ld\n", (ULONG)GetSCyl());
	FPrintf(h, ECYL_COMMAND" %ld\n", (ULONG)GetECyl());

	FPrintf(h, LABEL_COMMAND" \"%s\"\n", GetDiskName());
	FPrintf(h, FILENAME_COMMAND" \"%s\"\n", GetBufferName());
	FPrintf(h, XPKLIB_COMMAND" \"%s\"\n", GetXPKLibName());
	FPrintf(h, VDNAME_COMMAND" \"%s\"\n", GetDeviceName());
	FPrintf(h, VDNUMBER_COMMAND" %ld\n", (ULONG)GetVDNumber());
	FPrintf(h, RETRY_COMMAND" %ld\n", (ULONG)GetRetryNumber());
}
