#include "SD.h"
#include <devices/narrator.h>
#include <proto/translator.h>

#define PHONEMESSIZE 512

static BYTE AllocTries[]={ 1,2,4,8 }; /* we try all channels */
static unsigned char VoiceOpen;
static struct MsgPort *VoicePort;
static unsigned char *Phonemes;
static struct narrator_rb *rb;

struct Library *TranslatorBase;

/*
 * The following functions manage the voice system. They are called
 * *exclusively* from the main task.
 */

/*
 * Here we open the narrator.device, if someone selected Talk.
 */

int OpenVoice(void) {

	if (VoiceOpen) return(TRUE);

	if ((VoicePort = CreateMsgPort()) &&
		(rb = (void *)CreateIORequest(VoicePort, sizeof(struct narrator_rb))) &&
		(TranslatorBase = OpenLibrary("translator.library",0)) &&
		(Phonemes = AllocMem(PHONEMESSIZE, MEMF_PUBLIC | MEMF_CLEAR)) &&
		(VoiceOpen = !OpenDevice("narrator.device", 0, rb, 0))) {
		rb->message.io_Command = CMD_WRITE;
		rb->message.io_Data = (APTR)Phonemes;
		rb->ch_masks = AllocTries;
		rb->nm_masks = 4;
		return(TRUE);
	}

	CloseVoice();
	return(FALSE);
}

/*
 * Here we close the narrator.device.
 */

void CloseVoice(void) {

	if (VoiceOpen) {
		if (VoiceOpen == 2) WaitIO(rb);
		CloseDevice(rb);
		VoiceOpen = 0;
	}

	if (rb) {
		DeleteIORequest(rb);
		rb = NULL;
	}

	if (VoicePort) {
		DeleteMsgPort(VoicePort);
		VoicePort = NULL;
	}

	if (TranslatorBase) {
		CloseLibrary(TranslatorBase);
		TranslatorBase = NULL;
	}

	if (Phonemes) {
		FreeMem(Phonemes, PHONEMESSIZE);
		Phonemes = NULL;
	}
}

/*
 * And here we talk!
 * Note that Say() is *always* called---only it won't to anything if VoiceOpen==0.
 * Note also that since we use SendIO() the spoken message and the system
 * requester run concurrently 8^).
 */

void Say(unsigned char *Msg) {

	if (VoiceOpen) {
		if (VoiceOpen == 1) VoiceOpen = 2;
		else WaitIO(rb);
		Translate(Msg, strlen(Msg), Phonemes, PHONEMESSIZE);
		rb->message.io_Length = strlen(Phonemes);
		SendIO(rb);
	}
}
