package main

import (
	"errors"
	"bufio"
	"os"
	"regexp"
	"strconv"
)

func readFile(filename string) (examScores, error) {
	f, err := os.Open(filename)
	if err != nil {
		return nil, err
	}
	defer f.Close()
	scanner := bufio.NewScanner(f)
	res := make(examScores)
	for scanner.Scan() {
		s := scanner.Text()
		nome, punti, err := parseLine(s)
		if err != nil {
			return nil, err
		}
		res[nome] = punti
	}
	return res, nil
}

func parseLine(s string) (nome string, voti []int, err error) {
	r := regexp.MustCompile("[A-Za-z_]+")
	nome = r.FindString(s)
	r = regexp.MustCompile("[0-9]+")
	t := r.FindAllString(s, -1)
	for _, u := range t {
		v, e := strconv.Atoi(u)
		if e != nil {
			err = e
			return
		}
		if v == 31 || v > 32 || v == 0 {
			err = errors.New("Voto non ammissibile")
			return
		}
		voti = append(voti, v)
	}

	return
}