package main

import . "fmt"
import "os"

func main() {
	if len(os.Args) != 2 {
		Fprintf(os.Stderr, "Uso: %s FILE\n", os.Args[0])
		return
	}

	m, err := readFile(os.Args[1])
	if err != nil {
		Fprintln(os.Stderr, err)
		return
	}

	for nome, voti := range m {
		media30 := media(voti)
		media110 := 110 * media30 / 30
		Printf("Studente: %-20s    Media in 30esimi: %5.2f    Media in 110esimi: %6.2f\n", nome, media30, media110)
	}
}
